/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.PbesHmacAesWrapKeyEncryptionAlgorithm;

public class PbesHmacAesWrapKeyDecryptionAlgorithm
implements KeyDecryptionAlgorithm {
    private byte[] password;
    private String algo;

    public PbesHmacAesWrapKeyDecryptionAlgorithm(String password) {
        this(password, Algorithm.PBES2_HS256_A128KW.getJwtName(), false);
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(String password, String algo, boolean hashLargePasswords) {
        this(PbesHmacAesWrapKeyEncryptionAlgorithm.stringToBytes(password), algo, hashLargePasswords);
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(char[] password) {
        this(password, Algorithm.PBES2_HS256_A128KW.getJwtName(), false);
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(char[] password, String algo, boolean hashLargePasswords) {
        this(PbesHmacAesWrapKeyEncryptionAlgorithm.charsToBytes(password), algo, hashLargePasswords);
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(byte[] password) {
        this(password, Algorithm.PBES2_HS256_A128KW.getJwtName(), false);
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(byte[] password, String algo, boolean hashLargePasswords) {
        this.password = PbesHmacAesWrapKeyEncryptionAlgorithm.validatePassword(password, algo, hashLargePasswords);
        this.algo = algo;
    }

    @Override
    public byte[] getDecryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        JweHeaders jweHeaders = jweDecryptionInput.getJweHeaders();
        byte[] saltInput = this.getDecodedBytes(jweHeaders.getHeader("p2s"));
        int pbesCount = jweHeaders.getIntegerHeader("p2c");
        String keyAlgoJwt = jweHeaders.getAlgorithm();
        int keySize = PbesHmacAesWrapKeyEncryptionAlgorithm.getKeySize(keyAlgoJwt);
        byte[] derivedKey = PbesHmacAesWrapKeyEncryptionAlgorithm.createDerivedKey(keyAlgoJwt, keySize, this.password, saltInput, pbesCount);
        AesWrapKeyDecryptionAlgorithm aesWrap = new AesWrapKeyDecryptionAlgorithm(derivedKey){

            @Override
            protected boolean isValidAlgorithmFamily(String wrapAlgo) {
                return Algorithm.isPbesHsWrap(wrapAlgo);
            }
        };
        return aesWrap.getDecryptedContentEncryptionKey(jweDecryptionInput);
    }

    private byte[] getDecodedBytes(Object p2sHeader) {
        try {
            return Base64UrlUtility.decode((String)p2sHeader.toString());
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algo;
    }
}

