/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jws.EcDsaJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.PrivateKeyJwsSignatureProvider;

public class EcDsaJwsSignatureProvider
extends PrivateKeyJwsSignatureProvider {
    public EcDsaJwsSignatureProvider(ECPrivateKey key, String algo) {
        this(key, null, algo);
    }

    public EcDsaJwsSignatureProvider(ECPrivateKey key, AlgorithmParameterSpec spec, String algo) {
        this(key, null, spec, algo);
    }

    public EcDsaJwsSignatureProvider(ECPrivateKey key, SecureRandom random, AlgorithmParameterSpec spec, String algo) {
        super(key, random, spec, algo);
    }

    @Override
    protected boolean isValidAlgorithmFamily(String algo) {
        return Algorithm.isEcDsaSign(algo);
    }

    @Override
    protected JwsSignature doCreateJwsSignature(Signature s) {
        return new EcDsaPrivateKeyJwsSignature(s, EcDsaJwsSignatureVerifier.SIGNATURE_LENGTH_MAP.get(super.getAlgorithm()));
    }

    private static byte[] jcaOutputToJoseOutput(int jwsSignatureLen, byte[] jcaDer) {
        int requiredPartLen = jwsSignatureLen / 2;
        int rsDataBlockStart = jcaDer[1] == -127 ? 4 : 3;
        byte rPartLen = jcaDer[rsDataBlockStart];
        int rDataBlockStart = rsDataBlockStart + 1;
        int rPartLenDiff = rPartLen - requiredPartLen;
        int rValueStart = rDataBlockStart + EcDsaJwsSignatureProvider.getDataBlockOffset(jcaDer, rDataBlockStart, rPartLenDiff);
        int sPartStart = rDataBlockStart + rPartLen;
        byte sPartLen = jcaDer[sPartStart + 1];
        int sPartLenDiff = sPartLen - requiredPartLen;
        int sDataBlockStart = sPartStart + 2;
        int sValueStart = sDataBlockStart + EcDsaJwsSignatureProvider.getDataBlockOffset(jcaDer, sDataBlockStart, sPartLenDiff);
        byte[] result = new byte[jwsSignatureLen];
        System.arraycopy(jcaDer, rValueStart, result, rPartLenDiff < 0 ? rPartLenDiff * -1 : 0, rPartLenDiff < 0 ? requiredPartLen + rPartLenDiff : requiredPartLen);
        System.arraycopy(jcaDer, sValueStart, result, sPartLenDiff < 0 ? requiredPartLen + sPartLenDiff * -1 : requiredPartLen, sPartLenDiff < 0 ? requiredPartLen + sPartLenDiff : requiredPartLen);
        return result;
    }

    private static int getDataBlockOffset(byte[] jcaDer, int blockStart, int partLenDiff) {
        int i;
        if (partLenDiff > 0) {
            for (i = 0; i < partLenDiff && jcaDer[blockStart + i] == 0; ++i) {
            }
        }
        return i;
    }

    protected static class EcDsaPrivateKeyJwsSignature
    extends PrivateKeyJwsSignatureProvider.PrivateKeyJwsSignature {
        private int outLen;

        public EcDsaPrivateKeyJwsSignature(Signature s, int outLen) {
            super(s);
            this.outLen = outLen;
        }

        @Override
        public byte[] sign() {
            byte[] jcaDer = super.sign();
            return EcDsaJwsSignatureProvider.jcaOutputToJoseOutput(this.outLen, jcaDer);
        }
    }
}

