/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;

public final class IOUtils {
    public static final Charset UTF8_CHARSET = Charset.forName("utf-8");
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static String newStringFromBytes(byte[] bytes, String charsetName) {
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"" + charsetName + "\") returns invalid name.");
        }
    }

    public static String newStringFromBytes(byte[] bytes) {
        return IOUtils.newStringFromBytes(bytes, UTF8_CHARSET.name());
    }

    public static String newStringFromBytes(byte[] bytes, String charsetName, int start, int length) {
        try {
            return new String(bytes, start, length, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"" + charsetName + "\") returns invalid name.");
        }
    }

    public static String newStringFromBytes(byte[] bytes, int start, int length) {
        return IOUtils.newStringFromBytes(bytes, UTF8_CHARSET.name(), start, length);
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyAndCloseInput(InputStream input, OutputStream output) throws IOException {
        try {
            int n = IOUtils.copy(input, output, 4096);
            return n;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyAndCloseInput(InputStream input, OutputStream output, int bufferSize) throws IOException {
        try {
            int n = IOUtils.copy(input, output, bufferSize);
            return n;
        }
        finally {
            input.close();
        }
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int avail = input.available();
        if (avail > 262144) {
            avail = 262144;
        }
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        return total;
    }

    public static void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        n = input.read(buffer);
        while (-1 != n) {
            output.write(buffer, 0, n);
            n = input.read(buffer);
        }
    }

    public static String toString(InputStream input) throws IOException {
        return IOUtils.toString(input, 4096);
    }

    public static String toString(InputStream input, int bufferSize) throws IOException {
        int avail = input.available();
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        StringBuilder buf = new StringBuilder();
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        n = input.read(buffer);
        while (-1 != n) {
            buf.append(IOUtils.newStringFromBytes(buffer, 0, n));
            n = input.read(buffer);
        }
        input.close();
        return buf.toString();
    }

    public static String toString(Reader input) throws IOException {
        StringBuilder buf = new StringBuilder();
        char[] buffer = new char[4096];
        int n = 0;
        n = input.read(buffer);
        while (-1 != n) {
            buf.append(new String(buffer, 0, n));
            n = input.read(buffer);
        }
        input.close();
        return buf.toString();
    }

    public static String readStringFromStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        int i = in.read();
        while (i != -1) {
            sb.append((char)i);
            i = in.read();
        }
        in.close();
        return sb.toString();
    }

    public static ByteArrayInputStream loadIntoBAIS(InputStream in) throws IOException {
        int i = in.available();
        if (i < 4096) {
            i = 4096;
        }
        LoadingByteArrayOutputStream bout = new LoadingByteArrayOutputStream(i);
        IOUtils.copy(in, bout);
        in.close();
        return bout.createInputStream();
    }

    public static byte[] readBytesFromStream(InputStream in) throws IOException {
        int i = in.available();
        if (i < 4096) {
            i = 4096;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(i);
        IOUtils.copy(in, bos);
        in.close();
        return bos.toByteArray();
    }
}

