/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.source;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamDataWriter
implements DataWriter<XMLStreamWriter> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataWriter.class);

    @Override
    public void write(Object obj, MessagePartInfo part, XMLStreamWriter output) {
        this.write(obj, output);
    }

    @Override
    public void write(Object obj, XMLStreamWriter writer) {
        try {
            XMLStreamReader reader = null;
            if (obj instanceof DataSource) {
                DataSource ds = (DataSource)obj;
                reader = StaxUtils.createXMLStreamReader(ds.getInputStream());
                StaxUtils.copy(reader, writer);
                reader.close();
            } else if (obj instanceof Node) {
                Node nd = (Node)obj;
                if (writer instanceof W3CDOMStreamWriter && ((W3CDOMStreamWriter)writer).getCurrentNode() != null) {
                    W3CDOMStreamWriter dw = (W3CDOMStreamWriter)writer;
                    if (nd.getOwnerDocument() == dw.getCurrentNode().getOwnerDocument()) {
                        dw.getCurrentNode().appendChild(nd);
                        return;
                    }
                    if (nd instanceof DocumentFragment) {
                        nd = dw.getDocument().importNode(nd, true);
                        dw.getCurrentNode().appendChild(nd);
                        return;
                    }
                }
                StaxUtils.writeNode(nd, writer, true);
            } else {
                Source s = (Source)obj;
                if (s instanceof DOMSource && ((DOMSource)s).getNode() == null) {
                    return;
                }
                StaxUtils.copy(s, writer);
            }
        }
        catch (XMLStreamException e) {
            throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
        }
        catch (IOException e) {
            throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
        }
    }

    @Override
    public void setSchema(Schema s) {
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
    }

    @Override
    public void setProperty(String key, Object value) {
    }
}

