/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSource {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLSource.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(XMLSource.class);
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private InputStream stream;
    private boolean buffering;

    public XMLSource(InputStream is) {
        this.stream = is;
    }

    public void setBuffering(boolean enable) {
        this.buffering = enable;
        if (!this.stream.markSupported()) {
            try {
                this.stream = IOUtils.loadIntoBAIS(this.stream);
            }
            catch (IOException ex) {
                LOG.warning(new Message("NO_SOURCE_MARK", BUNDLE, new Object[0]).toString());
            }
        }
    }

    public <T> T getNode(String expression, Class<T> cls) {
        return this.getNode(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class), cls);
    }

    public <T> T getNode(String expression, Map<String, String> namespaces, Class<T> cls) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContextImpl(namespaces));
        try {
            Node node = (Node)xpath.evaluate(expression, this.getSource(), XPathConstants.NODE);
            if (node == null) {
                return null;
            }
            DOMSource ds = new DOMSource(node);
            return this.readFromSource(ds, cls);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("Illegal XPath expression '" + expression + "'", ex);
        }
    }

    public <T> T[] getNodes(String expression, Class<T> cls) {
        return this.getNodes(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class), cls);
    }

    public <T> T[] getNodes(String expression, Map<String, String> namespaces, Class<T> cls) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContextImpl(namespaces));
        try {
            NodeList nodes = (NodeList)xpath.evaluate(expression, this.getSource(), XPathConstants.NODESET);
            if (nodes == null || nodes.getLength() == 0) {
                return null;
            }
            Object[] values = (Object[])Array.newInstance(cls, nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                DOMSource ds = new DOMSource(nodes.item(i));
                values[i] = this.readFromSource(ds, cls);
            }
            return values;
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("Illegal XPath expression '" + expression + "'", ex);
        }
    }

    public URI getLink(String expression) {
        return this.getLink(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class));
    }

    public URI getLink(String expression, Map<String, String> namespaces) {
        String value = this.getValue(expression, namespaces);
        return value == null ? null : URI.create(value);
    }

    public URI getBaseURI() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("xml", XML_NAMESPACE);
        return this.getLink("/*/@xml:base", map);
    }

    public String getValue(String expression) {
        return this.getValue(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class));
    }

    public String getValue(String expression, Map<String, String> namespaces) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContextImpl(namespaces));
        try {
            return (String)xpath.evaluate(expression, this.getSource(), XPathConstants.STRING);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("Illegal XPath expression '" + expression + "'", ex);
        }
    }

    private <T> T readFromSource(Source s, Class<T> cls) {
        try {
            JAXBElementProvider provider = new JAXBElementProvider();
            JAXBContext c = provider.getPackageContext(cls);
            if (c == null) {
                c = provider.getClassContext(cls);
            }
            Unmarshaller u = c.createUnmarshaller();
            return cls.cast(u.unmarshal(s));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private InputSource getSource() {
        try {
            if (this.buffering) {
                this.stream.reset();
                this.stream.mark(this.stream.available());
            }
        }
        catch (IOException ex) {
            LOG.warning(new Message("NO_SOURCE_MARK", BUNDLE, new Object[0]).toString());
        }
        return new InputSource(this.stream);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamespaceContextImpl
    implements NamespaceContext {
        private Map<String, String> namespaces;

        public NamespaceContextImpl(Map<String, String> namespaces) {
            this.namespaces = namespaces;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.namespaces.get(prefix);
        }

        @Override
        public String getPrefix(String namespace) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                if (!entry.getValue().equals(namespace)) continue;
                return entry.getKey();
            }
            return null;
        }

        public Iterator getPrefixes(String namespace) {
            String prefix = this.namespaces.get(namespace);
            if (prefix == null) {
                return null;
            }
            return Collections.singletonList(prefix).iterator();
        }
    }
}

