/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyConstants {
    public static final String NAMESPACE_WS_POLICY = "http://www.w3.org/ns/ws-policy";
    public static final String NAMESPACE_W3_200607 = "http://www.w3.org/2006/07/ws-policy";
    public static final String NAMESPACE_XMLSOAP_200409 = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    public static final String POLICY_ELEM_NAME = "Policy";
    public static final String POLICYREFERENCE_ELEM_NAME = "PolicyReference";
    public static final String POLICYATTACHMENT_ELEM_NAME = "PolicyAttachment";
    public static final String APPLIESTO_ELEM_NAME = "AppliesTo";
    public static final String WSU_NAMESPACE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static final String WSU_ID_ATTR_NAME = "Id";
    public static final String POLICY_OVERRIDE = "org.apache.cxf.ws.policy.override";
    public static final String POLICY_IN_INTERCEPTOR_ID = "org.apache.cxf.ws.policy.PolicyInInterceptor";
    public static final String POLICY_OUT_INTERCEPTOR_ID = "org.apache.cxf.ws.policy.PolicyOutInterceptor";
    public static final String CLIENT_POLICY_IN_FAULT_INTERCEPTOR_ID = "org.apache.cxf.ws.policy.ClientPolicyInFaultInterceptor";
    public static final String SERVER_POLICY_OUT_FAULT_INTERCEPTOR_ID = "org.apache.cxf.ws.policy.ServerPolicyOutFaultInterceptor";
    public static final String CLIENT_OUT_ASSERTIONS = "org.apache.cxf.ws.policy.client.out.assertions";
    public static final String CLIENT_IN_ASSERTIONS = "org.apache.cxf.ws.policy.client.in.assertions";
    public static final String CLIENT_INFAULT_ASSERTIONS = "org.apache.cxf.ws.policy.client.infault.assertions";
    public static final String SERVER_IN_ASSERTIONS = "org.apache.cxf.ws.policy.server.in.assertions";
    public static final String SERVER_OUT_ASSERTIONS = "org.apache.cxf.ws.policy.server.out.assertions";
    public static final String SERVER_OUTFAULT_ASSERTIONS = "org.apache.cxf.ws.policy.server.outfault.assertions";
    private static final String ALL_ELEM_NAME = "All";
    private static final String EXACTLYONE_ELEM_NAME = "ExactlyOne";
    private static final String OPTIONAL_ATTR_NAME = "Optional";
    private static final String POLICYURIS_ATTR_NAME = "PolicyURIs";
    private static final Set<String> SUPPORTED_NAMESPACES = new HashSet<String>();

    private PolicyConstants() {
    }

    public static List<Element> findAllPolicyElementsOfLocalName(Document doc, String localName) {
        return PolicyConstants.findAllPolicyElementsOfLocalName(doc.getDocumentElement(), localName);
    }

    public static List<Element> findAllPolicyElementsOfLocalName(Element el, String localName) {
        LinkedList<Element> ret = new LinkedList<Element>();
        PolicyConstants.findAllPolicyElementsOfLocalName(el, localName, ret);
        return ret;
    }

    public static void findAllPolicyElementsOfLocalName(Element el, String localName, List<Element> val) {
        if (localName.equals(el.getLocalName()) && SUPPORTED_NAMESPACES.contains(el.getNamespaceURI())) {
            val.add(el);
        }
        el = DOMUtils.getFirstElement(el);
        while (el != null) {
            PolicyConstants.findAllPolicyElementsOfLocalName(el, localName, val);
            el = DOMUtils.getNextElement(el);
        }
    }

    public static boolean isOptional(Element e) {
        Attr at = PolicyConstants.findOptionalAttribute(e);
        if (at != null) {
            String v = at.getValue();
            return "true".equalsIgnoreCase(v) || "1".equals(v);
        }
        return false;
    }

    public static Attr findOptionalAttribute(Element e) {
        NamedNodeMap atts = e.getAttributes();
        for (int x = 0; x < atts.getLength(); ++x) {
            Attr att = (Attr)atts.item(x);
            QName qn = new QName(att.getNamespaceURI(), att.getLocalName());
            if (!PolicyConstants.isOptionalAttribute(qn)) continue;
            return att;
        }
        return null;
    }

    public static Element findPolicyElement(Element parent) {
        for (Node nd = parent.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (!POLICY_ELEM_NAME.equals(nd.getLocalName()) || !SUPPORTED_NAMESPACES.contains(nd.getNamespaceURI())) continue;
            return (Element)nd;
        }
        return null;
    }

    public static boolean isOptionalAttribute(QName qn) {
        return OPTIONAL_ATTR_NAME.equals(qn.getLocalPart()) && SUPPORTED_NAMESPACES.contains(qn.getNamespaceURI());
    }

    public static boolean isPolicyElem(QName qn) {
        return POLICY_ELEM_NAME.equals(qn.getLocalPart()) && SUPPORTED_NAMESPACES.contains(qn.getNamespaceURI());
    }

    public static boolean isPolicyRefElem(QName qn) {
        return POLICYREFERENCE_ELEM_NAME.equals(qn.getLocalPart()) && SUPPORTED_NAMESPACES.contains(qn.getNamespaceURI());
    }

    public static boolean isAppliesToElem(QName qn) {
        return APPLIESTO_ELEM_NAME.equals(qn.getLocalPart()) && SUPPORTED_NAMESPACES.contains(qn.getNamespaceURI());
    }

    public static boolean isPolicyURIsAttr(QName qn) {
        return POLICYURIS_ATTR_NAME.equals(qn.getLocalPart()) && SUPPORTED_NAMESPACES.contains(qn.getNamespaceURI());
    }

    public static boolean isExactlyOne(QName qn) {
        return EXACTLYONE_ELEM_NAME.equals(qn.getLocalPart()) && SUPPORTED_NAMESPACES.contains(qn.getNamespaceURI());
    }

    public static boolean isAll(QName qn) {
        return ALL_ELEM_NAME.equals(qn.getLocalPart()) && SUPPORTED_NAMESPACES.contains(qn.getNamespaceURI());
    }

    static {
        SUPPORTED_NAMESPACES.add(NAMESPACE_WS_POLICY);
        SUPPORTED_NAMESPACES.add(NAMESPACE_W3_200607);
        SUPPORTED_NAMESPACES.add(NAMESPACE_XMLSOAP_200409);
    }
}

