/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.blueprint;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintResourceFactory
implements ResourceProvider {
    private BlueprintContainer blueprintContainer;
    private Constructor<?> c;
    private String beanId;
    private Method postConstructMethod;
    private Method preDestroyMethod;
    private boolean isSingleton;

    public BlueprintResourceFactory() {
    }

    public BlueprintResourceFactory(String name) {
        this.beanId = name;
    }

    private void init() {
        Class type = ClassHelper.getRealClassFromClass(this.blueprintContainer.getComponentInstance(this.beanId).getClass());
        if (Proxy.isProxyClass(type)) {
            type = ClassHelper.getRealClass(this.blueprintContainer.getComponentInstance(this.beanId));
        }
        this.c = ResourceUtils.findResourceConstructor(type, !this.isSingleton());
        if (this.c == null) {
            throw new RuntimeException("Resource class " + type + " has no valid constructor");
        }
        this.postConstructMethod = ResourceUtils.findPostConstructMethod(type);
        this.preDestroyMethod = ResourceUtils.findPreDestroyMethod(type);
        ComponentMetadata component = this.blueprintContainer.getComponentMetadata(this.beanId);
        if (component instanceof BeanMetadata) {
            BeanMetadata local = (BeanMetadata)component;
            this.isSingleton = "singleton".equals(local.getScope()) || local.getScope() == null && local.getId() != null;
        }
    }

    @Override
    public Object getInstance(Message m) {
        Object instance;
        Object[] values = ResourceUtils.createConstructorArguments(this.c, m);
        Object object = instance = values.length > 0 ? this.blueprintContainer.getComponentInstance(this.beanId) : this.blueprintContainer.getComponentInstance(this.beanId);
        if (!this.isSingleton || m == null) {
            InjectionUtils.invokeLifeCycleMethod(instance, this.postConstructMethod);
        }
        return instance;
    }

    @Override
    public boolean isSingleton() {
        return this.isSingleton;
    }

    @Override
    public void releaseInstance(Message m, Object o) {
        if (!this.isSingleton) {
            InjectionUtils.invokeLifeCycleMethod(o, this.preDestroyMethod);
        }
    }

    public void setBeanId(String serviceBeanId) {
        this.beanId = serviceBeanId;
    }

    Constructor getBeanConstructor() {
        return this.c;
    }

    @Override
    public Class<?> getResourceClass() {
        return this.c.getDeclaringClass();
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
        this.init();
    }
}

