/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestImpl
implements Request {
    private final Message m;
    private final HttpHeaders headers;

    public RequestImpl(Message m) {
        this.m = m;
        this.headers = new HttpHeadersImpl(m);
    }

    public Variant selectVariant(List<Variant> vars) throws IllegalArgumentException {
        if (vars == null || vars.isEmpty()) {
            throw new IllegalArgumentException("List of Variants is either null or empty");
        }
        MediaType inMediaType = this.headers.getMediaType();
        Locale inLang = this.headers.getLanguage();
        String inEnc = (String)this.headers.getRequestHeaders().getFirst((Object)"Content-Encoding");
        LinkedList<Variant> matchingVars = new LinkedList<Variant>();
        for (Variant var : vars) {
            boolean langMatched;
            MediaType mt = var.getMediaType();
            Locale lang = var.getLanguage();
            String enc = var.getEncoding();
            boolean mtMatched = mt == null || inMediaType == null || JAXRSUtils.intersectMimeTypes(Collections.singletonList(inMediaType), mt).size() != 0;
            boolean encMatched = inEnc == null || enc == null || inEnc.equalsIgnoreCase(enc);
            boolean bl = langMatched = inLang == null || lang == null || inLang.equals(lang);
            if (!mtMatched || !encMatched || !langMatched) continue;
            matchingVars.add(var);
        }
        if (matchingVars.size() > 1) {
            Collections.sort(matchingVars, new VariantComparator());
        }
        return matchingVars.isEmpty() ? null : (Variant)matchingVars.get(0);
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        Response.ResponseBuilder rb = this.evaluateIfMatch(eTag);
        if (rb == null) {
            rb = this.evaluateIfNonMatch(eTag);
        }
        return rb;
    }

    private Response.ResponseBuilder evaluateIfMatch(EntityTag eTag) {
        List ifMatch = this.headers.getRequestHeader("If-Match");
        if (ifMatch == null || ifMatch.size() == 0) {
            return null;
        }
        try {
            for (String value : ifMatch) {
                if ("*".equals(value)) {
                    return null;
                }
                EntityTag requestTag = EntityTag.valueOf((String)value);
                if (requestTag.isWeak() || eTag.isWeak() || !requestTag.equals((Object)eTag)) continue;
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag(eTag);
    }

    private Response.ResponseBuilder evaluateIfNonMatch(EntityTag eTag) {
        List ifNonMatch = this.headers.getRequestHeader("If-None-Match");
        if (ifNonMatch == null || ifNonMatch.size() == 0) {
            return null;
        }
        String method = this.getMethod();
        boolean getOrHead = "GET".equals(method) || "HEAD".equals(method);
        try {
            for (String value : ifNonMatch) {
                boolean result = "*".equals(value);
                if (!result) {
                    EntityTag requestTag = EntityTag.valueOf((String)value);
                    boolean bl = getOrHead ? requestTag.equals((Object)eTag) : (result = !requestTag.isWeak() && !eTag.isWeak() && requestTag.equals((Object)eTag));
                }
                if (!result) continue;
                Response.Status status = getOrHead ? Response.Status.NOT_MODIFIED : Response.Status.PRECONDITION_FAILED;
                return Response.status((Response.Status)status).tag(eTag);
            }
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        return null;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        List ifModifiedSince = this.headers.getRequestHeader("If-Modified-Since");
        if (ifModifiedSince == null || ifModifiedSince.size() == 0) {
            return this.evaluateIfNotModifiedSince(lastModified);
        }
        SimpleDateFormat dateFormat = HttpUtils.getHttpDateFormat();
        dateFormat.setLenient(false);
        Date dateSince = null;
        try {
            dateSince = dateFormat.parse((String)ifModifiedSince.get(0));
        }
        catch (ParseException ex) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED);
        }
        if (dateSince.before(lastModified)) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED);
    }

    public Response.ResponseBuilder evaluateIfNotModifiedSince(Date lastModified) {
        List ifNotModifiedSince = this.headers.getRequestHeader("If-Unmodified-Since");
        if (ifNotModifiedSince == null || ifNotModifiedSince.size() == 0) {
            return null;
        }
        SimpleDateFormat dateFormat = HttpUtils.getHttpDateFormat();
        dateFormat.setLenient(false);
        Date dateSince = null;
        try {
            dateSince = dateFormat.parse((String)ifNotModifiedSince.get(0));
        }
        catch (ParseException ex) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED);
        }
        if (dateSince.before(lastModified)) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED);
        }
        return null;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        Response.ResponseBuilder rb = this.evaluatePreconditions(eTag);
        if (rb != null) {
            return rb;
        }
        return this.evaluatePreconditions(lastModified);
    }

    public String getMethod() {
        return this.m.get("org.apache.cxf.request.method").toString();
    }

    public Response.ResponseBuilder evaluatePreconditions() {
        List ifMatch = this.headers.getRequestHeader("If-Match");
        if (ifMatch != null) {
            for (String value : ifMatch) {
                if ("*".equals(value)) continue;
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag(EntityTag.valueOf((String)value));
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VariantComparator
    implements Comparator<Variant> {
        private VariantComparator() {
        }

        @Override
        public int compare(Variant v1, Variant v2) {
            int result = VariantComparator.compareMediaTypes(v1.getMediaType(), v2.getMediaType());
            if (result != 0) {
                return result;
            }
            result = VariantComparator.compareLanguages(v1.getLanguage(), v2.getLanguage());
            if (result == 0) {
                result = VariantComparator.compareEncodings(v1.getEncoding(), v2.getEncoding());
            }
            return result;
        }

        private static int compareMediaTypes(MediaType mt1, MediaType mt2) {
            if (mt1 != null && mt2 == null) {
                return -1;
            }
            if (mt1 == null && mt2 != null) {
                return 1;
            }
            return JAXRSUtils.compareMediaTypes(mt1, mt2);
        }

        private static int compareLanguages(Locale l1, Locale l2) {
            if (l1 != null && l2 == null) {
                return -1;
            }
            if (l1 == null && l2 != null) {
                return 1;
            }
            return 0;
        }

        private static int compareEncodings(String enc1, String enc2) {
            if (enc1 != null && enc2 == null) {
                return -1;
            }
            if (enc1 == null && enc2 != null) {
                return 1;
            }
            return 0;
        }
    }
}

