/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.feature;

import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Logging;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;

@NoJSR250Annotations
public class LoggingFeature
extends AbstractFeature {
    private static final int DEFAULT_LIMIT = 65536;
    private static final LoggingInInterceptor IN = new LoggingInInterceptor(65536);
    private static final LoggingOutInterceptor OUT = new LoggingOutInterceptor(65536);
    String inLocation;
    String outLocation;
    boolean prettyLogging;
    boolean showBinary;
    int limit = 65536;

    public LoggingFeature() {
    }

    public LoggingFeature(int lim) {
        this.limit = lim;
    }

    public LoggingFeature(String in, String out) {
        this.inLocation = in;
        this.outLocation = out;
    }

    public LoggingFeature(String in, String out, int lim) {
        this.inLocation = in;
        this.outLocation = out;
        this.limit = lim;
    }

    public LoggingFeature(String in, String out, int lim, boolean p) {
        this.inLocation = in;
        this.outLocation = out;
        this.limit = lim;
        this.prettyLogging = p;
    }

    public LoggingFeature(String in, String out, int lim, boolean p, boolean showBinary) {
        this(in, out, lim, p);
        this.showBinary = showBinary;
    }

    public LoggingFeature(Logging annotation) {
        this.inLocation = annotation.inLocation();
        this.outLocation = annotation.outLocation();
        this.limit = annotation.limit();
        this.prettyLogging = annotation.pretty();
        this.showBinary = annotation.showBinary();
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        if (this.limit == 65536 && this.inLocation == null && this.outLocation == null && !this.prettyLogging) {
            provider.getInInterceptors().add(IN);
            provider.getInFaultInterceptors().add(IN);
            provider.getOutInterceptors().add(OUT);
            provider.getOutFaultInterceptors().add(OUT);
        } else {
            LoggingInInterceptor in = new LoggingInInterceptor(this.limit);
            in.setOutputLocation(this.inLocation);
            in.setPrettyLogging(this.prettyLogging);
            in.setShowBinaryContent(this.showBinary);
            LoggingOutInterceptor out = new LoggingOutInterceptor(this.limit);
            out.setOutputLocation(this.outLocation);
            out.setPrettyLogging(this.prettyLogging);
            out.setShowBinaryContent(this.showBinary);
            provider.getInInterceptors().add(in);
            provider.getInFaultInterceptors().add(in);
            provider.getOutInterceptors().add(out);
            provider.getOutFaultInterceptors().add(out);
        }
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isPrettyLogging() {
        return this.prettyLogging;
    }

    public void setPrettyLogging(boolean prettyLogging) {
        this.prettyLogging = prettyLogging;
    }
}

