/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

public abstract class BeanResourceInfo
extends AbstractResourceInfo {
    protected List<Field> paramFields;
    protected List<Method> paramMethods;
    private boolean paramsAvailable;

    protected BeanResourceInfo(Bus bus) {
        super(bus);
    }

    protected BeanResourceInfo(Class<?> resourceClass, Class<?> serviceClass, boolean isRoot, Bus bus) {
        this(resourceClass, serviceClass, isRoot, true, bus);
    }

    protected BeanResourceInfo(Class<?> resourceClass, Class<?> serviceClass, boolean isRoot, boolean checkContexts, Bus bus) {
        super(resourceClass, serviceClass, isRoot, checkContexts, bus);
        if (checkContexts && resourceClass != null) {
            this.setParamField(serviceClass);
            this.setParamMethods(serviceClass);
        }
    }

    public boolean paramsAvailable() {
        return this.paramsAvailable;
    }

    private void setParamField(Class<?> cls) {
        if (Object.class == cls || cls == null) {
            return;
        }
        for (Field f : cls.getDeclaredFields()) {
            for (Annotation a : f.getAnnotations()) {
                if (!AnnotationUtils.isParamAnnotationClass(a.annotationType())) continue;
                if (this.paramFields == null) {
                    this.paramFields = new ArrayList<Field>();
                }
                this.paramsAvailable = true;
                this.paramFields.add(f);
            }
        }
        this.setParamField(cls.getSuperclass());
    }

    private void setParamMethods(Class<?> cls) {
        Class<?>[] interfaces;
        block0: for (Method m : cls.getMethods()) {
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1) continue;
            for (Annotation a : m.getAnnotations()) {
                if (!AnnotationUtils.isParamAnnotationClass(a.annotationType())) continue;
                this.checkParamMethod(m, AnnotationUtils.getAnnotationValue(a));
                continue block0;
            }
        }
        for (Class<?> i : interfaces = cls.getInterfaces()) {
            this.setParamMethods(i);
        }
    }

    private void addParamMethod(Method m) {
        if (this.paramMethods == null) {
            this.paramMethods = new ArrayList<Method>();
        }
        this.paramsAvailable = true;
        this.paramMethods.add(m);
    }

    public List<Method> getParameterMethods() {
        return this.paramMethods == null ? Collections.emptyList() : Collections.unmodifiableList(this.paramMethods);
    }

    public List<Field> getParameterFields() {
        return this.paramFields == null ? Collections.emptyList() : Collections.unmodifiableList(this.paramFields);
    }

    private void checkParamMethod(Method m, String value) {
        if (m.getName().equalsIgnoreCase("set" + value)) {
            this.addParamMethod(m);
        }
    }
}

