/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.EncryptionToken;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.ProtectionToken;
import org.apache.cxf.ws.security.policy.model.SignatureToken;
import org.apache.cxf.ws.security.policy.model.SymmetricAsymmetricBindingBase;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

public class SymmetricBinding
extends SymmetricAsymmetricBindingBase {
    private EncryptionToken encryptionToken;
    private SignatureToken signatureToken;
    private ProtectionToken protectionToken;

    public SymmetricBinding(SPConstants version) {
        super(version);
    }

    public EncryptionToken getEncryptionToken() {
        return this.encryptionToken;
    }

    public void setEncryptionToken(EncryptionToken encryptionToken) {
        if (this.protectionToken != null) {
            // empty if block
        }
        this.encryptionToken = encryptionToken;
    }

    public ProtectionToken getProtectionToken() {
        return this.protectionToken;
    }

    public void setProtectionToken(ProtectionToken protectionToken) {
        if (this.encryptionToken != null || this.signatureToken != null) {
            // empty if block
        }
        this.protectionToken = protectionToken;
    }

    public SignatureToken getSignatureToken() {
        return this.signatureToken;
    }

    public void setSignatureToken(SignatureToken signatureToken) {
        if (this.protectionToken != null) {
            // empty if block
        }
        this.signatureToken = signatureToken;
    }

    public QName getName() {
        return this.constants.getSymmetricBinding();
    }

    public PolicyComponent normalize() {
        if (this.isNormalized()) {
            return this;
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        List<Assertion> configurations = algorithmSuite.getConfigurations();
        Policy policy = new Policy();
        ExactlyOne exactlyOne = new ExactlyOne();
        Iterator<Assertion> iterator = configurations.iterator();
        while (iterator.hasNext()) {
            All wrapper = new All();
            SymmetricBinding symmetricBinding = new SymmetricBinding(this.constants);
            algorithmSuite = (AlgorithmSuite)iterator.next();
            symmetricBinding.setAlgorithmSuite(algorithmSuite);
            symmetricBinding.setEncryptionToken(this.getEncryptionToken());
            symmetricBinding.setEntireHeadersAndBodySignatures(this.isEntireHeadersAndBodySignatures());
            symmetricBinding.setIncludeTimestamp(this.isIncludeTimestamp());
            symmetricBinding.setLayout(this.getLayout());
            symmetricBinding.setProtectionOrder(this.getProtectionOrder());
            symmetricBinding.setProtectionToken(this.getProtectionToken());
            symmetricBinding.setSignatureProtection(this.isSignatureProtection());
            symmetricBinding.setSignatureToken(this.getSignatureToken());
            symmetricBinding.setSignedEndorsingSupportingTokens(this.getSignedEndorsingSupportingTokens());
            symmetricBinding.setSignedSupportingToken(this.getSignedSupportingToken());
            symmetricBinding.setTokenProtection(this.isTokenProtection());
            symmetricBinding.setNormalized(true);
            wrapper.addPolicyComponent((PolicyComponent)symmetricBinding);
            exactlyOne.addPolicyComponent((PolicyComponent)wrapper);
        }
        policy.addPolicyComponent((PolicyComponent)exactlyOne);
        return policy;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String prefix;
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String policyLocalName = SPConstants.POLICY.getLocalPart();
        String policyNamespaceURI = SPConstants.POLICY.getNamespaceURI();
        String wspWriterPrefix = writer.getPrefix(policyNamespaceURI);
        if (wspWriterPrefix == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, policyNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        writer.writeStartElement(wspPrefix, policyLocalName, policyNamespaceURI);
        if (this.encryptionToken != null) {
            this.encryptionToken.serialize(writer);
        } else if (this.protectionToken != null) {
            this.protectionToken.serialize(writer);
        } else {
            throw new RuntimeException("Either EncryptionToken or ProtectionToken must be set");
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        if (algorithmSuite == null) {
            throw new RuntimeException("AlgorithmSuite must be set");
        }
        algorithmSuite.serialize(writer);
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.serialize(writer);
        }
        if (this.isIncludeTimestamp()) {
            writer.writeStartElement(prefix, "IncludeTimestamp", namespaceURI);
            writer.writeEndElement();
        }
        if ("EncryptBeforeSigning".equals(this.getProtectionOrder())) {
            writer.writeStartElement(prefix, "EncryptBeforeSigning", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isSignatureProtection()) {
            writer.writeStartElement(prefix, "EncryptSignature", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isEntireHeadersAndBodySignatures()) {
            writer.writeEmptyElement(prefix, "OnlySignEntireHeadersAndBody", namespaceURI);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

