/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.encoded;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cxf.aegis.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalRegistry
implements Iterable<Object> {
    private final Map<Object, String> instances = new IdentityHashMap<Object, String>();
    private final Map<String, Object> notMarshalled = new LinkedHashMap<String, Object>();
    private int nextId;

    public static MarshalRegistry get(Context context) {
        MarshalRegistry marshalRegistry = context.getProperty(MarshalRegistry.class);
        if (marshalRegistry == null) {
            marshalRegistry = new MarshalRegistry();
            context.setProperty(marshalRegistry);
        }
        return marshalRegistry;
    }

    public String getInstanceId(Object instance) {
        String id = this.instances.get(instance);
        if (id == null) {
            id = "" + this.nextId++;
            this.instances.put(instance, id);
            this.notMarshalled.put(id, instance);
        }
        return id;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return !MarshalRegistry.this.notMarshalled.isEmpty();
            }

            @Override
            public Object next() {
                Iterator iterator = MarshalRegistry.this.notMarshalled.values().iterator();
                Object instance = iterator.next();
                iterator.remove();
                return instance;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

