/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.continuations;

import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSContinuation
implements Continuation {
    private Bus bus;
    private Message inMessage;
    private MessageObserver incomingObserver;
    private Collection<JMSContinuation> continuations;
    private Object userObject;
    private boolean isNew = true;
    private boolean isPending;
    private boolean isResumed;
    private Timer timer = new Timer();

    public JMSContinuation(Bus b, Message m, MessageObserver observer, Collection<JMSContinuation> cList) {
        this.bus = b;
        this.inMessage = m;
        this.incomingObserver = observer;
        this.continuations = cList;
    }

    @Override
    public Object getObject() {
        return this.userObject;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public boolean isPending() {
        return this.isPending;
    }

    @Override
    public boolean isResumed() {
        return this.isResumed;
    }

    @Override
    public void reset() {
        this.cancelTimerTask();
        this.isNew = true;
        this.isPending = false;
        this.isResumed = false;
    }

    @Override
    public void resume() {
        if (this.isResumed || !this.isPending) {
            return;
        }
        this.isResumed = true;
        this.cancelTimerTask();
        this.doResume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doResume() {
        this.continuations.remove(this);
        BusFactory.setThreadDefaultBus(this.bus);
        try {
            this.incomingObserver.onMessage(this.inMessage);
        }
        finally {
            this.isPending = false;
            BusFactory.setThreadDefaultBus(null);
        }
    }

    @Override
    public void setObject(Object o) {
        this.userObject = o;
    }

    @Override
    public boolean suspend(long timeout) {
        if (this.isPending) {
            return false;
        }
        this.continuations.add(this);
        this.isNew = false;
        this.isResumed = false;
        this.isPending = true;
        if (timeout > 0L) {
            this.createTimerTask(timeout);
        }
        throw new SuspendedInvocationException();
    }

    protected void createTimerTask(long timeout) {
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JMSContinuation jMSContinuation = JMSContinuation.this;
                synchronized (jMSContinuation) {
                    if (JMSContinuation.this.isPending) {
                        JMSContinuation.this.doResume();
                    }
                }
            }
        }, timeout);
    }

    protected void cancelTimerTask() {
        this.timer.cancel();
    }
}

