/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.StringMapImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.Destination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
extends StringMapImpl
implements Message {
    static int count;
    private Collection<Attachment> attachments;
    private Exchange exchange;
    private String id;
    private InterceptorChain interceptorChain;
    private Map<Class<?>, Object> contents = new IdentityHashMap(6);

    @Override
    public Collection<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.attachments = attachments;
        this.put(ATTACHMENTS, attachments);
    }

    public String getAttachmentMimeType() {
        return null;
    }

    @Override
    public Destination getDestination() {
        return this.get(Destination.class);
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Override
    public <T> T getContent(Class<T> format) {
        return format.cast(this.contents.get(format));
    }

    @Override
    public <T> void setContent(Class<T> format, Object content) {
        this.contents.put(format, content);
    }

    @Override
    public <T> void removeContent(Class<T> format) {
        this.contents.remove(format);
    }

    @Override
    public Set<Class<?>> getContentFormats() {
        return this.contents.keySet();
    }

    public void setDestination(Destination d) {
        this.put(Destination.class, d);
    }

    @Override
    public void setExchange(Exchange e) {
        this.exchange = e;
    }

    @Override
    public void setId(String i) {
        this.id = i;
    }

    @Override
    public void setInterceptorChain(InterceptorChain ic) {
        this.interceptorChain = ic;
    }

    @Override
    public Object getContextualProperty(String key) {
        Object ep;
        Object val = this.get(key);
        Exchange ex = this.getExchange();
        if (val == null) {
            val = ex.get(key);
        }
        if (val == null && (ep = this.get(OperationInfo.class)) != null) {
            val = ((AbstractPropertiesHolder)ep).getProperty(key);
        }
        if (val == null && (ep = ex.get(Endpoint.class)) != null) {
            val = ep.get(key);
            if (val == null) {
                val = ep.getEndpointInfo().getProperty(key);
            }
            if (val == null) {
                val = ep.getEndpointInfo().getBinding().getProperty(key);
            }
        }
        if (val == null && (ep = ex.get(Service.class)) != null) {
            val = ep.get(key);
        }
        return val;
    }

    public static void copyContent(Message m1, Message m2) {
        for (Class<?> c : m1.getContentFormats()) {
            m2.setContent(c, m1.getContent(c));
        }
    }
}

