/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSListenerPool;
import org.apache.cxf.transport.jms.JMSListenerPoolableObjectFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSOutputStream;
import org.apache.cxf.transport.jms.JMSUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;

public class JMSConduit
extends AbstractConduit
implements JMSExchangeSender,
MessageListener {
    static final Logger LOG = LogUtils.getL7dLogger(JMSConduit.class);
    private static final String CORRELATED = JMSConduit.class.getName() + ".correlated";
    private JMSListenerPool listenerPool;
    private EndpointInfo endpointInfo;
    private JMSConfiguration jmsConfig;
    private Map<String, Exchange> correlationMap;
    private Map<String, DefaultMessageListenerContainer> listenerMap;
    private DefaultMessageListenerContainer jmsListener;
    private String conduitId;
    private AtomicLong messageCount;
    private JmsTemplate jmsTemplate;

    public JMSConduit(EndpointInfo endpointInfo, EndpointReferenceType target, JMSConfiguration jmsConfig) {
        super(target);
        this.jmsConfig = jmsConfig;
        this.endpointInfo = endpointInfo;
        this.correlationMap = new ConcurrentHashMap<String, Exchange>();
        this.listenerMap = new ConcurrentHashMap<String, DefaultMessageListenerContainer>();
        this.conduitId = UUID.randomUUID().toString().replaceAll("-", "");
        this.messageCount = new AtomicLong(0L);
        this.listenerPool = new JMSListenerPool(new JMSListenerPoolableObjectFactory(jmsConfig, this));
    }

    public void prepare(Message message) throws IOException {
        String name = this.endpointInfo.getName().toString() + ".jms-conduit";
        org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INSUFFICIENT_CONFIGURATION_CONDUIT", LOG, name);
        this.jmsConfig.ensureProperlyConfigured(msg);
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        JMSOutputStream out = new JMSOutputStream(this, message.getExchange(), isTextPayload);
        message.setContent(OutputStream.class, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendExchange(Exchange exchange, final Object request) {
        String correlationId;
        DefaultMessageListenerContainer listener = null;
        LOG.log(Level.FINE, "JMSConduit send message");
        final Message outMessage = exchange.getOutMessage();
        if (outMessage == null) {
            throw new RuntimeException("Exchange to be sent has no outMessage");
        }
        JMSMessageHeadersType headers = (JMSMessageHeadersType)outMessage.get("org.apache.cxf.jms.client.request.headers");
        this.jmsTemplate = JMSFactory.createJmsTemplate(this.jmsConfig, headers);
        Destination replyTo = null;
        if (!exchange.isOneWay()) {
            if (this.jmsConfig.isUseMessageIDAsCorrelationID()) {
                if (!exchange.isSynchronous()) {
                    try {
                        listener = (DefaultMessageListenerContainer)this.listenerPool.borrowObject();
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, "Unable to borrow listener from pool: " + ex);
                        throw new RuntimeException("Unable to borrow listener from pool.", ex);
                    }
                    replyTo = listener.getDestination();
                } else {
                    String replyToName = this.jmsConfig.getReplyDestination();
                    replyTo = JMSFactory.resolveOrCreateDestination(this.jmsTemplate, replyToName, this.jmsConfig.isPubSubDomain());
                }
            } else {
                if (this.jmsListener == null) {
                    this.jmsListener = JMSFactory.createJmsListener(this.jmsConfig, this, this.jmsConfig.getReplyDestination(), this.conduitId, true);
                }
                replyTo = this.jmsListener.getDestination();
            }
        }
        String string = correlationId = headers != null && headers.isSetJMSCorrelationID() ? headers.getJMSCorrelationID() : JMSUtils.createCorrelationId(this.jmsConfig.getConduitSelectorPrefix() + this.conduitId, this.messageCount.incrementAndGet());
        if (this.jmsConfig.isUseMessageIDAsCorrelationID()) {
            correlationId = null;
        }
        if (exchange.isOneWay() && !this.jmsConfig.isEnforceSpec() && JMSConduit.isSetReplyTo(outMessage)) {
            String replyToName;
            String string2 = replyToName = headers != null ? headers.getJMSReplyTo() : null;
            if (replyToName == null && this.jmsConfig.getReplyDestination() != null) {
                replyToName = this.jmsConfig.getReplyDestination();
            }
            if (replyToName != null) {
                replyTo = JMSFactory.resolveOrCreateDestination(this.jmsTemplate, replyToName, this.jmsConfig.isPubSubDomain());
            }
        }
        String replyToDestination = this.jmsConfig.getReplyToDestination();
        Destination destination = null;
        if (replyToDestination != null) {
            destination = JMSFactory.resolveOrCreateDestination(this.jmsTemplate, replyToDestination, this.jmsConfig.isPubSubDomain());
        }
        final Destination rtd = destination == null ? replyTo : destination;
        final String cid = correlationId;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class JMSConduitMessageCreator
        implements MessageCreator {
            javax.jms.Message jmsMessage;

            public javax.jms.Message createMessage(Session session) throws JMSException {
                String messageType = JMSConduit.this.jmsConfig.getMessageType();
                this.jmsMessage = JMSUtils.buildJMSMessageFromCXFMessage(outMessage, request, messageType, session, rtd, cid);
                LOG.log(Level.FINE, "client sending request: ", this.jmsMessage);
                return this.jmsMessage;
            }
        }
        JMSConduitMessageCreator messageCreator = new JMSConduitMessageCreator();
        if (!exchange.isOneWay()) {
            Exchange exchange2 = exchange;
            synchronized (exchange2) {
                if (correlationId != null) {
                    this.correlationMap.put(correlationId, exchange);
                }
                this.jmsTemplate.send(this.jmsConfig.getTargetDestination(), (MessageCreator)messageCreator);
                if (this.jmsConfig.isUseMessageIDAsCorrelationID()) {
                    try {
                        correlationId = messageCreator.jmsMessage.getJMSMessageID();
                        this.handleMessageIDAsCorrelationID(correlationId, exchange, replyTo, listener);
                    }
                    catch (JMSException jmsex) {
                        throw JmsUtils.convertJmsAccessException((JMSException)jmsex);
                    }
                }
                if (exchange.isSynchronous()) {
                    try {
                        exchange.wait(this.jmsTemplate.getReceiveTimeout());
                    }
                    catch (InterruptedException e) {
                        this.correlationMap.remove(correlationId);
                        throw new RuntimeException(e);
                    }
                    this.correlationMap.remove(correlationId);
                    if (exchange.get(CORRELATED) == null) {
                        throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
                    }
                }
            }
        }
        this.jmsTemplate.send(this.jmsConfig.getTargetDestination(), (MessageCreator)messageCreator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleMessageIDAsCorrelationID(String correlationId, Exchange exchange, Destination replyTo, DefaultMessageListenerContainer listener) {
        String messageSelector = "JMSCorrelationID='" + correlationId + "'";
        if (exchange.isSynchronous()) {
            javax.jms.Message message = this.jmsTemplate.receiveSelected(replyTo, messageSelector);
            if (message == null) throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
            this.handleMessage(exchange, message);
            return;
        } else {
            listener.setMessageListener((Object)this);
            this.correlationMap.put(correlationId, exchange);
            listener.setMessageSelector("JMSCorrelationID='" + correlationId + "'");
            if (!listener.isActive()) {
                listener.initialize();
            }
            this.listenerMap.put(correlationId, listener);
        }
    }

    public void onMessage(javax.jms.Message jmsMessage) {
        String correlationId;
        try {
            correlationId = jmsMessage.getJMSCorrelationID();
        }
        catch (JMSException e) {
            throw JmsUtils.convertJmsAccessException((JMSException)e);
        }
        Exchange exchange = this.correlationMap.remove(correlationId);
        DefaultMessageListenerContainer listener = this.listenerMap.get(correlationId);
        if (listener != null) {
            try {
                this.listenerPool.returnObject(listener);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Could not return listener to pool: " + ex);
            }
        }
        if (exchange == null) {
            LOG.log(Level.WARNING, "Could not correlate message with correlationId " + correlationId);
            return;
        }
        this.handleMessage(exchange, jmsMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Exchange exchange, javax.jms.Message jmsMessage) {
        MessageImpl inMessage = new MessageImpl();
        exchange.setInMessage(inMessage);
        LOG.log(Level.FINE, "client received reply: ", jmsMessage);
        try {
            JMSUtils.populateIncomingContext(jmsMessage, inMessage, "org.apache.cxf.jms.client.response.headers");
            byte[] response = JMSUtils.retrievePayload(jmsMessage, (String)inMessage.get(Message.ENCODING));
            LOG.log(Level.FINE, "The Response Message payload is : [" + response + "]");
            inMessage.setContent(InputStream.class, new ByteArrayInputStream(response));
            if (exchange.isSynchronous()) {
                Exchange exchange2 = exchange;
                synchronized (exchange2) {
                    exchange.put(CORRELATED, Boolean.TRUE);
                    exchange.notifyAll();
                }
            }
            if (this.incomingObserver != null) {
                this.incomingObserver.onMessage(exchange.getInMessage());
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().log(Level.WARNING, "can't get the right encoding information " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JMSConduit jMSConduit = this;
        synchronized (jMSConduit) {
            if (this.listenerPool != null) {
                try {
                    this.listenerPool.close();
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Failed to close JMSListener pool: " + ex);
                }
                finally {
                    this.listenerPool = null;
                }
            }
            if (this.jmsListener != null) {
                this.jmsListener.shutdown();
                this.jmsListener = null;
            }
            if (this.jmsTemplate != null) {
                ConnectionFactory obj = this.jmsTemplate.getConnectionFactory();
                if (obj instanceof SingleConnectionFactory) {
                    LOG.log(Level.FINE, "Destroying SingleConnectionFactory from template .....");
                    ((SingleConnectionFactory)obj).destroy();
                }
                this.jmsTemplate = null;
            }
            LOG.log(Level.FINE, "JMSConduit closed ");
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected static boolean isSetReplyTo(Message message) {
        Boolean ret = (Boolean)message.get("org.apache.cxf.jms.client.set.replyto");
        return ret == null || ret != null && ret != false;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

