/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfigurationException;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSOutputStream;
import org.apache.cxf.transport.jms.JMSUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;

public class JMSConduit
extends AbstractConduit
implements JMSExchangeSender,
MessageListener {
    static final Logger LOG = LogUtils.getL7dLogger(JMSConduit.class);
    private static final String CORRELATED = JMSConduit.class.getName() + ".correlated";
    private EndpointInfo endpointInfo;
    private JMSConfiguration jmsConfig;
    private Map<String, Exchange> correlationMap;
    private DefaultMessageListenerContainer jmsListener;
    private DefaultMessageListenerContainer allListener;
    private String conduitId;
    private AtomicLong messageCount;
    private JMSBusLifeCycleListener listener;
    private Bus bus;

    public JMSConduit(EndpointInfo endpointInfo, EndpointReferenceType target, JMSConfiguration jmsConfig, Bus b) {
        super(target);
        this.bus = b;
        this.jmsConfig = jmsConfig;
        this.endpointInfo = endpointInfo;
        this.correlationMap = new ConcurrentHashMap<String, Exchange>();
        this.conduitId = UUID.randomUUID().toString().replaceAll("-", "");
        this.messageCount = new AtomicLong(0L);
    }

    public void prepare(org.apache.cxf.message.Message message) throws IOException {
        String name = this.endpointInfo.getName().toString() + ".jms-conduit";
        org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INSUFFICIENT_CONFIGURATION_CONDUIT", LOG, name);
        this.jmsConfig.ensureProperlyConfigured(msg);
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        JMSOutputStream out = new JMSOutputStream(this, message.getExchange(), isTextPayload);
        message.setContent(OutputStream.class, out);
    }

    private synchronized AbstractMessageListenerContainer getJMSListener() {
        if (this.jmsListener == null) {
            this.jmsListener = JMSFactory.createJmsListener(this.jmsConfig, this, this.jmsConfig.getReplyDestination(), this.conduitId, false);
            this.addBusListener();
        }
        return this.jmsListener;
    }

    private synchronized AbstractMessageListenerContainer getAllListener() {
        if (this.allListener == null) {
            this.allListener = JMSFactory.createJmsListener(this.jmsConfig, this, this.jmsConfig.getReplyDestination(), null, true);
            this.addBusListener();
        }
        return this.allListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendExchange(final Exchange exchange, final Object request) {
        LOG.log(Level.FINE, "JMSConduit send message");
        final org.apache.cxf.message.Message outMessage = exchange.getOutMessage();
        if (outMessage == null) {
            throw new RuntimeException("Exchange to be sent has no outMessage");
        }
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        if (isTextPayload && MessageUtils.isTrue(outMessage.getContextualProperty("mtom-enabled")) && outMessage.getAttachments() != null && outMessage.getAttachments().size() > 0) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INVALID_MESSAGE_TYPE", LOG, new Object[0]);
            throw new ConfigurationException(msg);
        }
        final JMSMessageHeadersType headers = (JMSMessageHeadersType)outMessage.get("org.apache.cxf.jms.client.request.headers");
        final JmsTemplate jmsTemplate = JMSFactory.createJmsTemplate(this.jmsConfig, headers);
        String userCID = headers != null ? headers.getJMSCorrelationID() : null;
        DefaultMessageListenerContainer jmsList = this.jmsListener;
        if (!exchange.isOneWay()) {
            jmsList = userCID == null || !this.jmsConfig.isUseConduitIdSelector() ? this.getJMSListener() : this.getAllListener();
        }
        final Destination replyTo = exchange.isOneWay() ? null : jmsList.getDestination();
        final String correlationId = headers != null && headers.isSetJMSCorrelationID() ? headers.getJMSCorrelationID() : JMSUtils.createCorrelationId(this.jmsConfig.getConduitSelectorPrefix() + this.conduitId, this.messageCount.incrementAndGet());
        MessageCreator messageCreator = new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                String messageType = JMSConduit.this.jmsConfig.getMessageType();
                Destination replyToDestination = replyTo;
                if (exchange.isOneWay() && !JMSConduit.this.jmsConfig.isEnforceSpec() && JMSConduit.isSetReplyTo(outMessage)) {
                    String replyToName;
                    String string = replyToName = headers != null ? headers.getJMSReplyTo() : null;
                    if (replyToName == null && JMSConduit.this.jmsConfig.getReplyDestination() != null) {
                        replyToName = JMSConduit.this.jmsConfig.getReplyDestination();
                    }
                    if (replyToName != null) {
                        replyToDestination = JMSFactory.resolveOrCreateDestination(jmsTemplate, replyToName, JMSConduit.this.jmsConfig.isPubSubDomain());
                    }
                }
                Message jmsMessage = JMSUtils.buildJMSMessageFromCXFMessage(outMessage, request, messageType, session, replyToDestination, correlationId);
                LOG.log(Level.FINE, "client sending request: ", jmsMessage);
                return jmsMessage;
            }
        };
        if (!exchange.isOneWay()) {
            Exchange exchange2 = exchange;
            synchronized (exchange2) {
                this.correlationMap.put(correlationId, exchange);
                jmsTemplate.send(this.jmsConfig.getTargetDestination(), messageCreator);
                if (exchange.isSynchronous()) {
                    try {
                        exchange.wait(jmsTemplate.getReceiveTimeout());
                    }
                    catch (InterruptedException e) {
                        this.correlationMap.remove(correlationId);
                        throw new RuntimeException(e);
                    }
                    this.correlationMap.remove(correlationId);
                    if (exchange.get(CORRELATED) == null) {
                        throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
                    }
                }
            }
        }
        jmsTemplate.send(this.jmsConfig.getTargetDestination(), messageCreator);
    }

    private synchronized void addBusListener() {
        BusLifeCycleManager blcm;
        if (this.listener == null && this.bus != null && (blcm = this.bus.getExtension(BusLifeCycleManager.class)) != null) {
            this.listener = new JMSBusLifeCycleListener(this, blcm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message jmsMessage) {
        String correlationId;
        try {
            correlationId = jmsMessage.getJMSCorrelationID();
        }
        catch (JMSException e) {
            throw JmsUtils.convertJmsAccessException((JMSException)e);
        }
        Exchange exchange = this.correlationMap.remove(correlationId);
        if (exchange == null) {
            LOG.log(Level.WARNING, "Could not correlate message with correlationId " + correlationId);
            return;
        }
        MessageImpl inMessage = new MessageImpl();
        exchange.setInMessage(inMessage);
        LOG.log(Level.FINE, "client received reply: ", jmsMessage);
        try {
            JMSUtils.populateIncomingContext(jmsMessage, inMessage, "org.apache.cxf.jms.client.response.headers");
            byte[] response = JMSUtils.retrievePayload(jmsMessage, (String)inMessage.get(org.apache.cxf.message.Message.ENCODING));
            LOG.log(Level.FINE, "The Response Message payload is : [" + response + "]");
            inMessage.setContent(InputStream.class, new ByteArrayInputStream(response));
            if (exchange.isSynchronous()) {
                Exchange exchange2 = exchange;
                synchronized (exchange2) {
                    exchange.put(CORRELATED, Boolean.TRUE);
                    exchange.notifyAll();
                }
            }
            if (this.incomingObserver != null) {
                this.incomingObserver.onMessage(exchange.getInMessage());
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().log(Level.WARNING, "can't get the right encoding information " + ex);
        }
    }

    public synchronized void close() {
        if (this.listener != null) {
            this.listener.unreg();
            this.listener = null;
        }
        if (this.jmsListener != null) {
            this.jmsListener.shutdown();
        }
        if (this.allListener != null) {
            this.allListener.shutdown();
        }
        this.jmsConfig.destroyWrappedConnectionFactory();
        LOG.log(Level.FINE, "JMSConduit closed ");
    }

    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected static boolean isSetReplyTo(org.apache.cxf.message.Message message) {
        Boolean ret = (Boolean)message.get("org.apache.cxf.jms.client.set.replyto");
        return ret == null || ret != null && ret != false;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    static class JMSBusLifeCycleListener
    implements BusLifeCycleListener {
        final WeakReference<JMSConduit> ref;
        BusLifeCycleManager blcm;

        JMSBusLifeCycleListener(JMSConduit c, BusLifeCycleManager b) {
            this.ref = new WeakReference<JMSConduit>(c);
            this.blcm = b;
            this.blcm.registerLifeCycleListener(this);
        }

        public void initComplete() {
        }

        public void postShutdown() {
        }

        public void preShutdown() {
            this.unreg();
            this.blcm = null;
            JMSConduit c = (JMSConduit)this.ref.get();
            if (c != null) {
                c.listener = null;
                c.close();
            }
        }

        public void unreg() {
            if (this.blcm != null) {
                this.blcm.unregisterLifeCycleListener(this);
            }
        }
    }
}

