/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.RelatesToType;

public class AddressingPropertiesImpl
implements AddressingProperties {
    private EndpointReferenceType to;
    private AttributedURIType toURIType;
    private EndpointReferenceType from;
    private AttributedURIType messageID;
    private EndpointReferenceType replyTo;
    private EndpointReferenceType faultTo;
    private RelatesToType relatesTo;
    private AttributedURIType action;
    private String namespaceURI;
    private QName duplicate;
    private List<QName> mustUnderstand;

    public AddressingPropertiesImpl() {
        this("http://www.w3.org/2005/08/addressing");
    }

    public AddressingPropertiesImpl(String uri) {
        this.namespaceURI = uri;
    }

    @Override
    public EndpointReferenceType getToEndpointReference() {
        return this.to;
    }

    @Override
    public AttributedURIType getTo() {
        if (this.toURIType == null) {
            return null != this.to ? this.to.getAddress() : null;
        }
        return this.toURIType;
    }

    @Override
    public void setTo(AttributedURIType t) {
        this.toURIType = t;
    }

    @Override
    public void setTo(EndpointReferenceType epr) {
        this.to = epr;
        this.toURIType = null;
    }

    @Override
    public EndpointReferenceType getFrom() {
        return this.from;
    }

    @Override
    public void setFrom(EndpointReferenceType epr) {
        this.from = epr;
    }

    @Override
    public AttributedURIType getMessageID() {
        return this.messageID;
    }

    @Override
    public void setMessageID(AttributedURIType iri) {
        this.messageID = iri;
    }

    @Override
    public EndpointReferenceType getReplyTo() {
        return this.replyTo;
    }

    @Override
    public void setReplyTo(EndpointReferenceType ref) {
        this.replyTo = ref;
    }

    @Override
    public EndpointReferenceType getFaultTo() {
        return this.faultTo;
    }

    @Override
    public void setFaultTo(EndpointReferenceType ref) {
        this.faultTo = ref;
    }

    @Override
    public RelatesToType getRelatesTo() {
        return this.relatesTo;
    }

    @Override
    public void setRelatesTo(RelatesToType rel) {
        this.relatesTo = rel;
    }

    @Override
    public AttributedURIType getAction() {
        return this.action;
    }

    @Override
    public void setAction(AttributedURIType iri) {
        this.action = iri;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public void exposeAs(String uri) {
        this.namespaceURI = uri;
    }

    @Override
    public void setDuplicate(QName dup) {
        this.duplicate = dup;
    }

    @Override
    public QName getDuplicate() {
        return this.duplicate;
    }

    @Override
    public List<QName> getMustUnderstand() {
        if (this.mustUnderstand == null) {
            this.mustUnderstand = new ArrayList<QName>();
        }
        return this.mustUnderstand;
    }

    public String toString() {
        AttributedURIType address;
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        if (null != this.messageID) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append("MessageId: ");
            buf.append(this.messageID.getValue());
        }
        if (null != this.action) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append("Action: ");
            buf.append(this.action.getValue());
        }
        if (null != this.to) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append("To: ");
            buf.append(this.to.getAddress().getValue());
        }
        if (null != this.replyTo && null != (address = this.replyTo.getAddress())) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append("ReplyTo: ");
            buf.append(address.getValue());
        }
        if (null != this.faultTo && null != (address = this.faultTo.getAddress())) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append("FaultTo: ");
            buf.append(address.getValue());
        }
        if (null != this.relatesTo) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append("RelatesTo: ");
            buf.append(this.relatesTo.getValue());
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public AddressingProperties createCompatibleResponseProperties() {
        return new AddressingPropertiesImpl(this.getNamespaceURI());
    }
}

