/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.Collection;
import java.util.Date;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.interceptors.NegotiationUtils;
import org.apache.cxf.ws.security.policy.interceptors.STSInvoker;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.spnego.SpnegoTokenContext;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;

class SpnegoContextTokenInInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    static final Logger LOG = LogUtils.getL7dLogger(SpnegoContextTokenInInterceptor.class);

    public SpnegoContextTokenInInterceptor() {
        super("pre-protocol");
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        if (aim != null) {
            Collection ais = (Collection)aim.get(SP12Constants.SPNEGO_CONTEXT_TOKEN);
            if (ais == null || ais.isEmpty()) {
                return;
            }
            if (this.isRequestor(message)) {
                for (AssertionInfo ai : ais) {
                    ai.setAsserted(true);
                }
                return;
            }
            String s = (String)message.get("SOAPAction");
            AddressingProperties inProps = (AddressingProperties)message.getContextualProperty("javax.xml.ws.addressing.context.inbound");
            if (inProps != null && s == null) {
                s = inProps.getAction().getValue();
            }
            if (s != null && s.contains("/RST/Issue") && (s.startsWith("http://schemas.xmlsoap.org/ws/2005/02/trust") || s.startsWith("http://docs.oasis-open.org/ws-sx/ws-trust/200512"))) {
                Policy p = new Policy();
                ExactlyOne ea = new ExactlyOne();
                p.addPolicyComponent((PolicyComponent)ea);
                All all = new All();
                Assertion ass = NegotiationUtils.getAddressingPolicy(aim, false);
                all.addPolicyComponent((PolicyComponent)ass);
                ea.addPolicyComponent((PolicyComponent)all);
                this.unmapSecurityProps(message);
                String ns = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
                if (s.startsWith("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
                    ns = "http://schemas.xmlsoap.org/ws/2005/02/trust";
                }
                NegotiationUtils.recalcEffectivePolicy(message, ns, p, new SpnegoSTSInvoker(), false);
            } else {
                message.getInterceptorChain().add(SpnegoContextTokenFinderInterceptor.INSTANCE);
            }
        }
    }

    private void unmapSecurityProps(Message message) {
        Exchange ex = message.getExchange();
        for (String s : SecurityConstants.ALL_PROPERTIES) {
            Object v = message.getContextualProperty(s);
            if (v == null) continue;
            ex.put(s, v);
        }
    }

    static final class SpnegoContextTokenFinderInterceptor
    extends AbstractPhaseInterceptor<SoapMessage> {
        static final SpnegoContextTokenFinderInterceptor INSTANCE = new SpnegoContextTokenFinderInterceptor();

        private SpnegoContextTokenFinderInterceptor() {
            super("pre-protocol");
            this.addAfter(WSS4JInInterceptor.class.getName());
        }

        @Override
        public void handleMessage(SoapMessage message) throws Fault {
            boolean foundSCT = NegotiationUtils.parseSCTResult(message);
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection ais = (Collection)aim.get(SP12Constants.SPNEGO_CONTEXT_TOKEN);
                if (ais == null || ais.isEmpty()) {
                    return;
                }
                for (AssertionInfo inf : ais) {
                    if (foundSCT) {
                        inf.setAsserted(true);
                        continue;
                    }
                    inf.setNotAsserted("No SecurityContextToken token found in message.");
                }
            }
        }
    }

    public class SpnegoSTSInvoker
    extends STSInvoker {
        @Override
        void doIssue(Element requestEl, Exchange exchange, Element binaryExchange, W3CDOMStreamWriter writer, String prefix, String namespace) throws Exception {
            SpnegoTokenContext spnegoToken = this.handleBinaryExchange(binaryExchange, exchange.getInMessage(), namespace);
            writer.writeStartElement(prefix, "RequestSecurityTokenResponseCollection", namespace);
            writer.writeStartElement(prefix, "RequestSecurityTokenResponse", namespace);
            String context = requestEl.getAttributeNS(null, "Context");
            if (context != null && !"".equals(context)) {
                writer.writeAttribute("Context", context);
            }
            int keySize = 256;
            String tokenType = null;
            Element el = DOMUtils.getFirstElement(requestEl);
            while (el != null) {
                String localName = el.getLocalName();
                if (namespace.equals(el.getNamespaceURI())) {
                    if ("KeySize".equals(localName)) {
                        keySize = Integer.parseInt(el.getTextContent());
                    } else if ("TokenType".equals(localName)) {
                        tokenType = el.getTextContent();
                    }
                }
                el = DOMUtils.getNextElement(el);
            }
            if (keySize < 128 || keySize > 512) {
                keySize = 256;
            }
            writer.writeStartElement(prefix, "TokenType", namespace);
            writer.writeCharacters(tokenType);
            writer.writeEndElement();
            writer.writeStartElement(prefix, "RequestedSecurityToken", namespace);
            SecurityContextToken sct = new SecurityContextToken(NegotiationUtils.getWSCVersion(tokenType), writer.getDocument());
            Date created = new Date();
            Date expires = new Date();
            expires.setTime(created.getTime() + 300000L);
            SecurityToken token = new SecurityToken(sct.getIdentifier(), created, expires);
            token.setToken(sct.getElement());
            token.setTokenType(sct.getTokenType());
            writer.getCurrentNode().appendChild(sct.getElement());
            writer.writeEndElement();
            writer.writeStartElement(prefix, "RequestedAttachedReference", namespace);
            token.setAttachedReference(this.writeSecurityTokenReference(writer, "#" + sct.getID(), tokenType));
            writer.writeEndElement();
            writer.writeStartElement(prefix, "RequestedUnattachedReference", namespace);
            token.setUnattachedReference(this.writeSecurityTokenReference(writer, sct.getIdentifier(), tokenType));
            writer.writeEndElement();
            this.writeLifetime(writer, created, expires, prefix, namespace);
            writer.writeStartElement(prefix, "KeySize", namespace);
            writer.writeCharacters("" + keySize);
            writer.writeEndElement();
            byte[] secret = WSSecurityUtil.generateNonce((int)(keySize / 8));
            byte[] key = spnegoToken.wrapKey(secret);
            this.writeProofToken(writer, prefix, namespace, key);
            writer.writeEndElement();
            writer.writeEndElement();
            spnegoToken.clear();
            token.setSecret(secret);
            ((TokenStore)exchange.get(Endpoint.class).getEndpointInfo().getProperty(TokenStore.class.getName())).add(token);
        }

        private SpnegoTokenContext handleBinaryExchange(Element binaryExchange, Message message, String namespace) throws Exception {
            if (binaryExchange == null) {
                throw new Exception("No BinaryExchange element received");
            }
            String encoding = binaryExchange.getAttributeNS(null, "EncodingType");
            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary".equals(encoding)) {
                throw new Exception("Unknown encoding type: " + encoding);
            }
            String valueType = binaryExchange.getAttributeNS(null, "ValueType");
            if (!(namespace + "/spnego").equals(valueType)) {
                throw new Exception("Unknown value type: " + valueType);
            }
            String content = DOMUtils.getContent(binaryExchange);
            byte[] decodedContent = Base64.decode((String)content);
            String jaasContext = (String)message.getContextualProperty("ws-security.kerberos.jaas.context");
            String kerberosSpn = (String)message.getContextualProperty("ws-security.kerberos.spn");
            CallbackHandler callbackHandler = NegotiationUtils.getCallbackHandler(message.getContextualProperty("ws-security.callback-handler"), this.getClass());
            SpnegoTokenContext spnegoToken = new SpnegoTokenContext();
            spnegoToken.validateServiceTicket(jaasContext, callbackHandler, kerberosSpn, decodedContent);
            return spnegoToken;
        }

        private void writeProofToken(W3CDOMStreamWriter writer, String prefix, String namespace, byte[] key) throws Exception {
            writer.writeStartElement(prefix, "RequestedProofToken", namespace);
            writer.writeStartElement("xenc", "EncryptedKey", "http://www.w3.org/2001/04/xmlenc#");
            writer.writeStartElement("xenc", "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
            writer.writeAttribute("Algorithm", namespace + "/spnego#GSS_Wrap");
            writer.writeEndElement();
            writer.writeStartElement("xenc", "CipherData", "http://www.w3.org/2001/04/xmlenc#");
            writer.writeStartElement("xenc", "CipherValue", "http://www.w3.org/2001/04/xmlenc#");
            writer.writeCharacters(Base64.encode((byte[])key));
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }
}

