/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IriDecoderHelper {
    private IriDecoderHelper() {
    }

    public static List<Param> decodeIri(String uri, String loc) {
        char c;
        ArrayList<Param> values = new ArrayList<Param>();
        String path = IriDecoderHelper.getUriPath(uri);
        String locPath = IriDecoderHelper.getUriPath(loc);
        int idx2 = 0;
        for (int idx1 = 0; idx1 < locPath.length(); ++idx1) {
            c = locPath.charAt(idx1);
            if (c == '{') {
                if (locPath.charAt(idx1 + 1) == '{') {
                    IriDecoderHelper.expect(path, idx2++, '{');
                    continue;
                }
                int locEnd = locPath.indexOf(125, idx1);
                String name = locPath.substring(idx1 + 1, locEnd);
                idx1 = locEnd;
                String endFragment = IriDecoderHelper.getEndFragment(locEnd + 1, locPath);
                int end = IriDecoderHelper.findPartEnd(path, idx2, endFragment);
                String value = path.substring(idx2, end);
                idx2 = end;
                values.add(new Param(name, value));
                continue;
            }
            IriDecoderHelper.expect(path, idx2++, c);
        }
        if (idx2 < path.length() && (c = path.charAt(idx2++)) == '?') {
            int end = path.indexOf(35, idx2);
            if (end < 0) {
                end = path.length();
            }
            IriDecoderHelper.addParams(path, idx2, end, values);
        }
        return values;
    }

    private static String getEndFragment(int i, String locPath) {
        int end = locPath.indexOf(123, i);
        if (end == -1) {
            end = locPath.length();
        } else if (locPath.charAt(end + 1) == '{') {
            return IriDecoderHelper.getEndFragment(end + 1, locPath);
        }
        return locPath.substring(i, end);
    }

    public static void addParams(String input, int start, int stop, List<Param> params) {
        while (start < stop) {
            int eq = input.indexOf(61, start);
            int se = input.indexOf(38, eq);
            if (se < 0) {
                se = stop;
            }
            params.add(new Param(input.substring(start, eq), input.substring(eq + 1, se)));
            start = se + 1;
        }
    }

    public static int findPartEnd(String path, int c, String endFragment) {
        int end;
        int i = end = path.length();
        if (!"".equals(endFragment) && (i = path.indexOf(endFragment, c)) >= c && i < end) {
            end = i;
        }
        if ((i = path.indexOf(63, c)) >= c && i < end) {
            end = i;
        }
        return end;
    }

    public static void expect(String path, int index, char c) {
        if (path.charAt(index) != c) {
            throw new IllegalStateException("Unexpected character '" + c + "' at index " + index);
        }
    }

    public static String getUriPath(String uri) {
        int idx = uri.indexOf("://");
        int idx2 = uri.indexOf(47, idx + 3);
        return uri.substring(idx2 + 1);
    }

    public static String combine(String location, String httpLocation) {
        if (httpLocation == null) {
            return location;
        }
        if (httpLocation.indexOf("://") != -1) {
            return httpLocation;
        }
        if (location.endsWith("/")) {
            return location + httpLocation;
        }
        return location + "/" + httpLocation;
    }

    private static XmlSchemaType findSchemaType(Collection<SchemaInfo> schemas, QName name) {
        for (SchemaInfo inf : schemas) {
            if (!inf.getNamespaceURI().equals(name.getNamespaceURI())) continue;
            return inf.getSchema().getTypeByName(name);
        }
        return null;
    }

    public static Document buildDocument(XmlSchemaAnnotated schemaAnnotation, Collection<SchemaInfo> schemas, List<Param> params) {
        XmlSchemaElement element = null;
        QName qname = null;
        XmlSchemaComplexType cplxType = null;
        if (schemaAnnotation instanceof XmlSchemaElement) {
            element = (XmlSchemaElement)schemaAnnotation;
            qname = element.getQName();
            cplxType = (XmlSchemaComplexType)element.getSchemaType();
            if (cplxType == null) {
                cplxType = (XmlSchemaComplexType)IriDecoderHelper.findSchemaType(schemas, element.getSchemaTypeName());
            }
        }
        if (schemaAnnotation instanceof XmlSchemaComplexType) {
            cplxType = (XmlSchemaComplexType)schemaAnnotation;
            qname = cplxType.getQName();
        }
        Document doc = DOMUtils.createDocument();
        XmlSchemaSequence seq = (XmlSchemaSequence)cplxType.getParticle();
        Element e = doc.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        e.setAttribute("xmlns", qname.getNamespaceURI());
        doc.appendChild(e);
        if (seq == null || seq.getItems() == null) {
            return doc;
        }
        for (int i = 0; i < seq.getItems().getCount(); ++i) {
            XmlSchemaElement elChild = (XmlSchemaElement)seq.getItems().getItem(i);
            Param param = null;
            for (Param p : params) {
                if (!p.getName().equals(elChild.getQName().getLocalPart())) continue;
                param = p;
                break;
            }
            Element ec = doc.createElementNS(elChild.getQName().getNamespaceURI(), elChild.getQName().getLocalPart());
            if (!elChild.getQName().getNamespaceURI().equals(qname.getNamespaceURI())) {
                ec.setAttribute("xmlns", elChild.getQName().getNamespaceURI());
            }
            if (param != null) {
                params.remove(param);
                ec.appendChild(doc.createTextNode(param.getValue()));
            }
            e.appendChild(ec);
        }
        return doc;
    }

    public static Document interopolateParams(Document doc, XmlSchemaAnnotated schemaAnnotation, Collection<SchemaInfo> schemas, List<Param> params) {
        XmlSchemaElement element = null;
        QName qname = null;
        XmlSchemaComplexType cplxType = null;
        if (schemaAnnotation instanceof XmlSchemaElement) {
            element = (XmlSchemaElement)schemaAnnotation;
            qname = element.getQName();
            cplxType = (XmlSchemaComplexType)element.getSchemaType();
            if (cplxType == null) {
                cplxType = (XmlSchemaComplexType)IriDecoderHelper.findSchemaType(schemas, element.getSchemaTypeName());
            }
        }
        if (schemaAnnotation instanceof XmlSchemaComplexType) {
            cplxType = (XmlSchemaComplexType)schemaAnnotation;
            qname = cplxType.getQName();
        }
        XmlSchemaSequence seq = (XmlSchemaSequence)cplxType.getParticle();
        Element root = doc.getDocumentElement();
        if (root == null) {
            root = doc.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
            root.setAttribute("xmlns", qname.getNamespaceURI());
            doc.appendChild(root);
        }
        for (int i = 0; i < seq.getItems().getCount(); ++i) {
            XmlSchemaElement elChild = (XmlSchemaElement)seq.getItems().getItem(i);
            Param param = null;
            for (Param p : params) {
                if (!p.getName().equals(elChild.getQName().getLocalPart())) continue;
                param = p;
                break;
            }
            if (param == null) continue;
            Element ec = IriDecoderHelper.getElement(root, elChild.getQName());
            if (ec == null) {
                Element insertBeforeEl;
                ec = doc.createElementNS(elChild.getQName().getNamespaceURI(), elChild.getQName().getLocalPart());
                if (!elChild.getQName().getNamespaceURI().equals(qname.getNamespaceURI())) {
                    ec.setAttribute("xmlns", elChild.getQName().getNamespaceURI());
                }
                if ((insertBeforeEl = IriDecoderHelper.getIndexedElement(root, i)) != null) {
                    root.insertBefore(ec, insertBeforeEl);
                } else {
                    root.appendChild(ec);
                }
            } else {
                NodeList childNodes = ec.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node n = childNodes.item(j);
                    ec.removeChild(n);
                }
            }
            if (param == null) continue;
            params.remove(param);
            ec.appendChild(doc.createTextNode(param.getValue()));
        }
        return doc;
    }

    private static Element getIndexedElement(Element e, int i) {
        NodeList childNodes = e.getChildNodes();
        int elNum = 0;
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node n = childNodes.item(j);
            if (n.getNodeType() != 1) continue;
            if (i == elNum) {
                return (Element)n;
            }
            ++elNum;
        }
        return null;
    }

    private static Element getElement(Element element, QName name) {
        NodeList childNodes = element.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node n = childNodes.item(j);
            if (n.getNodeType() != 1 || !n.getLocalName().equals(name.getLocalPart()) || !n.getNamespaceURI().equals(name.getNamespaceURI())) continue;
            return (Element)n;
        }
        return null;
    }

    public static List<Param> decode(String uri, String loc, InputStream is) {
        List<Param> params = IriDecoderHelper.decodeIri(uri, loc);
        if (is != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                IOUtils.copy(is, baos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            IriDecoderHelper.addParams(baos.toString(), 0, baos.size(), params);
        }
        return params;
    }

    public static class Param {
        private final String name;
        private final String value;

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "[" + this.name + "=" + this.value + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Param other = (Param)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

