/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.saaj;

import java.util.Collection;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.headers.HeaderManager;
import org.apache.cxf.headers.HeaderProcessor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAAJInInterceptor
extends AbstractSoapInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SAAJInInterceptor.class);

    public SAAJInInterceptor() {
        super("pre-protocol");
    }

    public SAAJInInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(SoapMessage message) throws Fault {
        try {
            MessageFactory factory = null;
            factory = message.getVersion() instanceof Soap11 ? MessageFactory.newInstance() : MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
            SOAPMessage soapMessage = factory.createMessage();
            message.setContent(SOAPMessage.class, soapMessage);
            SOAPPart part = soapMessage.getSOAPPart();
            Document node = (Document)message.getContent(Node.class);
            DOMSource source = new DOMSource(node);
            part.setContent((Source)source);
            Collection<Attachment> atts = message.getAttachments();
            if (atts != null) {
                for (Attachment a : atts) {
                    AttachmentPart ap = soapMessage.createAttachmentPart(a.getDataHandler());
                    soapMessage.addAttachmentPart(ap);
                }
            }
            if (message.hasHeaders()) {
                SAAJInInterceptor.replaceHeaders(soapMessage, message);
            }
            XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
            StaxUtils.readDocElements((Node)soapMessage.getSOAPBody(), xmlReader, true);
            DOMSource bodySource = new DOMSource((Node)soapMessage.getSOAPPart().getEnvelope().getBody());
            xmlReader = StaxUtils.createXMLStreamReader(bodySource);
            xmlReader.nextTag();
            xmlReader.nextTag();
            message.setContent(XMLStreamReader.class, xmlReader);
        }
        catch (SOAPException soape) {
            throw new SoapFault(new Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), soape, message.getVersion().getSender());
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), e, message.getVersion().getSender());
        }
    }

    public static void replaceHeaders(SOAPMessage soapMessage, SoapMessage message) throws SOAPException {
        SOAPHeader header = soapMessage.getSOAPHeader();
        if (header == null) {
            return;
        }
        NodeList headerEls = header.getChildNodes();
        int len = headerEls.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = headerEls.item(i);
            if (1 != nd.getNodeType()) continue;
            Element hel = (Element)nd;
            Bus b = message.getExchange().get(Bus.class);
            HeaderProcessor p = null;
            if (b != null && b.getExtension(HeaderManager.class) != null) {
                p = b.getExtension(HeaderManager.class).getHeaderProcessor(hel.getNamespaceURI());
            }
            DataBinding dataBinding = null;
            Object obj = p == null || p.getDataBinding() == null ? nd : p.getDataBinding().createReader(Node.class).read(nd);
            SoapHeader shead = new SoapHeader(new QName(nd.getNamespaceURI(), nd.getLocalName()), obj, dataBinding);
            String mu = hel.getAttributeNS(message.getVersion().getNamespace(), message.getVersion().getAttrNameMustUnderstand());
            String act = hel.getAttributeNS(message.getVersion().getNamespace(), message.getVersion().getAttrNameRole());
            shead.setActor(act);
            shead.setMustUnderstand(Boolean.valueOf(mu) != false || "1".equals(mu));
            Header oldHdr = message.getHeader(new QName(nd.getNamespaceURI(), nd.getLocalName()));
            if (oldHdr != null) {
                message.getHeaders().remove(oldHdr);
            }
            message.getHeaders().add(shead);
        }
    }
}

