/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.jsse.spring;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.configuration.security.KeyManagersType;
import org.apache.cxf.configuration.security.KeyStoreType;
import org.apache.cxf.configuration.security.SecureRandomParameters;
import org.apache.cxf.configuration.security.TrustManagersType;

public final class TLSParameterJaxBUtils {
    private TLSParameterJaxBUtils() {
    }

    public static SecureRandom getSecureRandom(SecureRandomParameters secureRandomParams) throws GeneralSecurityException {
        SecureRandom secureRandom = null;
        if (secureRandomParams != null) {
            String secureRandomAlg = secureRandomParams.getAlgorithm();
            String randomProvider = secureRandomParams.getProvider();
            secureRandom = randomProvider != null ? (secureRandomAlg != null ? SecureRandom.getInstance(secureRandomAlg, randomProvider) : null) : (secureRandomAlg != null ? SecureRandom.getInstance(secureRandomAlg) : null);
        }
        return secureRandom;
    }

    public static KeyStore getKeyStore(KeyStoreType kst) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        if (kst == null) {
            return null;
        }
        String type = kst.isSetType() ? kst.getType() : KeyStore.getDefaultType();
        char[] password = kst.isSetPassword() ? kst.getPassword().toCharArray() : null;
        KeyStore keyStore2 = keyStore = !kst.isSetProvider() ? KeyStore.getInstance(type) : KeyStore.getInstance(type, kst.getProvider());
        if (kst.isSetFile()) {
            keyStore.load(new FileInputStream(kst.getFile()), password);
        }
        if (kst.isSetResource()) {
            keyStore.load(kst.getClass().getClassLoader().getResourceAsStream(kst.getResource()), password);
        }
        if (kst.isSetUrl()) {
            keyStore.load(new URL(kst.getUrl()).openStream(), password);
        }
        return keyStore;
    }

    public static KeyManager[] getKeyManagers(KeyManagersType kmc) throws GeneralSecurityException, IOException {
        KeyStore keyStore = TLSParameterJaxBUtils.getKeyStore(kmc.getKeyStore());
        if (keyStore == null) {
            return null;
        }
        String alg = kmc.isSetFactoryAlgorithm() ? kmc.getFactoryAlgorithm() : KeyManagerFactory.getDefaultAlgorithm();
        char[] keyPass = kmc.isSetKeyPassword() ? kmc.getKeyPassword().toCharArray() : null;
        KeyManagerFactory fac = kmc.isSetProvider() ? KeyManagerFactory.getInstance(alg, kmc.getProvider()) : KeyManagerFactory.getInstance(alg);
        fac.init(keyStore, keyPass);
        return fac.getKeyManagers();
    }

    public static TrustManager[] getTrustManagers(TrustManagersType kmc) throws GeneralSecurityException, IOException {
        KeyStore keyStore = TLSParameterJaxBUtils.getKeyStore(kmc.getKeyStore());
        if (keyStore == null) {
            return null;
        }
        String alg = kmc.isSetFactoryAlgorithm() ? kmc.getFactoryAlgorithm() : KeyManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory fac = kmc.isSetProvider() ? TrustManagerFactory.getInstance(alg, kmc.getProvider()) : TrustManagerFactory.getInstance(alg);
        fac.init(keyStore);
        return fac.getTrustManagers();
    }
}

