/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.spi.ServiceDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.binding.soap.JaxWsSoapBindingConfiguration;
import org.apache.cxf.jaxws.handler.HandlerResolverImpl;
import org.apache.cxf.jaxws.handler.PortInfoImpl;
import org.apache.cxf.jaxws.support.BindingID;
import org.apache.cxf.jaxws.support.DummyImpl;
import org.apache.cxf.jaxws.support.JaxWsClientEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.workqueue.OneShotAsyncExecutor;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceImpl
extends ServiceDelegate {
    private static final Logger LOG = LogUtils.getL7dLogger(ServiceImpl.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    private Bus bus;
    private String wsdlURL;
    private HandlerResolver handlerResolver;
    private final Collection<QName> ports = new HashSet<QName>();
    private Map<QName, PortInfoImpl> portInfos = new HashMap<QName, PortInfoImpl>();
    private Executor executor;
    private QName serviceName;
    private Class<?> clazz;

    public ServiceImpl(Bus b, URL url, QName name, Class<?> cls) {
        this.bus = b;
        this.wsdlURL = url == null ? null : url.toString();
        this.serviceName = name;
        this.clazz = cls;
        this.handlerResolver = new HandlerResolverImpl(this.bus, name, this.clazz);
        if (url != null) {
            try {
                this.initializePorts();
            }
            catch (ServiceConstructionException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
    }

    private void initializePorts() {
        WSDLServiceFactory sf = new WSDLServiceFactory(this.bus, this.wsdlURL, this.serviceName);
        Service service = sf.create();
        for (ServiceInfo si : service.getServiceInfos()) {
            for (EndpointInfo ei : si.getEndpoints()) {
                this.ports.add(ei.getName());
                String bindingID = BindingID.getJaxwsBindingID(ei.getTransportId());
                this.addPort(ei.getName(), bindingID, ei.getAddress());
            }
        }
    }

    public final void addPort(QName portName, String bindingId, String address) {
        PortInfoImpl portInfo = new PortInfoImpl(bindingId, portName, this.serviceName);
        portInfo.setAddress(address);
        this.portInfos.put(portName, portInfo);
    }

    private Endpoint getJaxwsEndpoint(QName portName, AbstractServiceFactoryBean sf) {
        Service service = sf.getService();
        EndpointInfo ei = null;
        if (portName == null) {
            ei = service.getServiceInfos().get(0).getEndpoints().iterator().next();
        } else {
            PortInfoImpl portInfo;
            ei = service.getEndpointInfo(portName);
            if (ei == null && null != (portInfo = this.getPortInfo(portName))) {
                try {
                    ei = this.createEndpointInfo(sf, portName, portInfo);
                }
                catch (BusException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
        }
        if (ei == null) {
            Message msg = new Message("INVALID_PORT", BUNDLE, portName);
            throw new WebServiceException(msg.toString());
        }
        try {
            return new JaxWsClientEndpointImpl(this.bus, service, ei, this);
        }
        catch (EndpointException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private AbstractServiceFactoryBean createDispatchService(DataBinding db) {
        AbstractServiceFactoryBean serviceFactory;
        Service dispatchService = null;
        if (null != this.wsdlURL) {
            WSDLServiceFactory sf = new WSDLServiceFactory(this.bus, this.wsdlURL, this.serviceName);
            dispatchService = sf.create();
            dispatchService.setDataBinding(db);
            serviceFactory = sf;
        } else {
            JaxWsServiceFactoryBean sf = new JaxWsServiceFactoryBean();
            sf.setBus(this.bus);
            sf.setServiceName(this.serviceName);
            ((ReflectionServiceFactoryBean)sf).setServiceClass(DummyImpl.class);
            sf.setDataBinding(db);
            dispatchService = sf.create();
            serviceFactory = sf;
        }
        this.configureObject(dispatchService);
        return serviceFactory;
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode) {
        AbstractServiceFactoryBean sf = null;
        try {
            sf = this.createDispatchService(new SourceDataBinding());
        }
        catch (ServiceConstructionException e) {
            throw new WebServiceException((Throwable)e);
        }
        Endpoint endpoint = this.getJaxwsEndpoint(portName, sf);
        DispatchImpl<T> disp = new DispatchImpl<T>(this.bus, mode, type, this.getExecutor(), endpoint);
        this.configureObject(disp);
        return disp;
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode) {
        AbstractServiceFactoryBean sf = null;
        try {
            sf = this.createDispatchService(new JAXBDataBinding(context));
        }
        catch (ServiceConstructionException e) {
            throw new WebServiceException((Throwable)e);
        }
        Endpoint endpoint = this.getJaxwsEndpoint(portName, sf);
        DispatchImpl<Object> disp = new DispatchImpl<Object>(this.bus, mode, context, Object.class, this.getExecutor(), endpoint);
        this.configureObject(disp);
        return disp;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    public <T> T getPort(Class<T> type) {
        try {
            return this.createPort(null, null, type);
        }
        catch (ServiceConstructionException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public <T> T getPort(QName portName, Class<T> type) {
        if (portName == null) {
            throw new WebServiceException(BUNDLE.getString("PORT_NAME_NULL_EXC"));
        }
        if (!this.ports.contains(portName) && !this.portInfos.containsKey(portName)) {
            throw new WebServiceException(new Message("INVALID_PORT", BUNDLE, portName).toString());
        }
        try {
            return this.createPort(portName, null, type);
        }
        catch (ServiceConstructionException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public <T> T getPort(EndpointReferenceType endpointReference, Class<T> type) {
        endpointReference = EndpointReferenceUtils.resolve(endpointReference, this.bus);
        QName serviceQName = EndpointReferenceUtils.getServiceName(endpointReference);
        String portName = EndpointReferenceUtils.getPortName(endpointReference);
        QName portQName = null;
        if (portName != null && serviceQName != null) {
            portQName = new QName(serviceQName.getNamespaceURI(), portName);
        }
        return this.createPort(portQName, endpointReference, type);
    }

    public Iterator<QName> getPorts() {
        return this.ports.iterator();
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public URL getWSDLDocumentLocation() {
        try {
            return new URL(this.wsdlURL);
        }
        catch (MalformedURLException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public void setExecutor(Executor e) {
        this.executor = e;
    }

    public void setHandlerResolver(HandlerResolver hr) {
        this.handlerResolver = hr;
    }

    public Bus getBus() {
        return this.bus;
    }

    protected <T> T createPort(QName portName, EndpointReferenceType epr, Class<T> serviceEndpointInterface) {
        PortInfoImpl portInfo;
        LOG.log(Level.FINE, "creating port for portName", portName);
        LOG.log(Level.FINE, "endpoint reference:", epr);
        LOG.log(Level.FINE, "endpoint interface:", serviceEndpointInterface);
        JaxWsProxyFactoryBean proxyFac = new JaxWsProxyFactoryBean();
        JaxWsClientFactoryBean clientFac = (JaxWsClientFactoryBean)proxyFac.getClientFactoryBean();
        ReflectionServiceFactoryBean serviceFactory = proxyFac.getServiceFactory();
        proxyFac.setBus(this.bus);
        proxyFac.setServiceClass(serviceEndpointInterface);
        proxyFac.setServiceName(this.serviceName);
        if (this.wsdlURL != null) {
            proxyFac.setWsdlURL(this.wsdlURL);
        }
        if (portName == null) {
            clientFac.create();
            portName = serviceFactory.getEndpointName();
        } else {
            serviceFactory.setEndpointName(portName);
        }
        if (epr != null) {
            clientFac.setEndpointReference(epr);
        }
        if ((portInfo = this.portInfos.get(portName)) != null) {
            clientFac.setBindingId(portInfo.getBindingID());
            clientFac.setAddress(portInfo.getAddress());
        }
        this.configureObject(portName.toString() + ".jaxws-client.proxyFactory", proxyFac);
        Object obj = proxyFac.create();
        Service service = serviceFactory.getService();
        service.setExecutor(new Executor(){

            public void execute(Runnable command) {
                Executor ex = ServiceImpl.this.getExecutor();
                if (ex == null) {
                    ex = OneShotAsyncExecutor.getInstance();
                }
                ex.execute(command);
            }
        });
        this.configureObject(service);
        JaxWsEndpointImpl jaxwsEndpoint = (JaxWsEndpointImpl)clientFac.getClient().getEndpoint();
        this.configureObject(jaxwsEndpoint);
        List hc = jaxwsEndpoint.getJaxwsBinding().getHandlerChain();
        hc.addAll(this.handlerResolver.getHandlerChain((PortInfo)this.portInfos.get(portName)));
        LOG.log(Level.FINE, "created proxy", obj);
        this.ports.add(portName);
        return serviceEndpointInterface.cast(obj);
    }

    private EndpointInfo createEndpointInfo(AbstractServiceFactoryBean serviceFactory, QName portName, PortInfoImpl portInfo) throws BusException {
        EndpointInfo ei = null;
        String address = portInfo.getAddress();
        DestinationFactoryManager dfm = this.bus.getExtension(DestinationFactoryManager.class);
        DestinationFactory df = dfm.getDestinationFactoryForUri(portInfo.getAddress());
        String transportId = df.getTransportIds().get(0);
        String bindingID = BindingID.getBindingID(portInfo.getBindingID());
        JaxWsSoapBindingConfiguration config = null;
        if (serviceFactory instanceof JaxWsServiceFactoryBean) {
            config = new JaxWsSoapBindingConfiguration((JaxWsServiceFactoryBean)serviceFactory);
        }
        BindingInfo bindingInfo = this.bus.getExtension(BindingFactoryManager.class).getBindingFactory(bindingID).createBindingInfo(serviceFactory.getService(), bindingID, config);
        Service service = serviceFactory.getService();
        service.getServiceInfos().get(0).addBinding(bindingInfo);
        ei = new EndpointInfo(service.getServiceInfos().get(0), transportId);
        ei.setName(portName);
        ei.setAddress(address);
        ei.setBinding(bindingInfo);
        service.getServiceInfos().get(0).addEndpoint(ei);
        return ei;
    }

    private void configureObject(Object instance) {
        this.configureObject(null, instance);
    }

    private void configureObject(String name, Object instance) {
        Configurer configurer = this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(name, instance);
        }
    }

    private PortInfoImpl getPortInfo(QName portName) {
        return this.portInfos.get(portName);
    }
}

