/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.databinding.jaxb;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.api.ClassNameAllocator;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.Property;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.TypeAndAnnotation;
import com.sun.tools.xjc.api.XJC;
import com.sun.tools.xjc.api.impl.s2j.SchemaCompilerImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.JAXBUtils;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.cxf.tools.wsdlto.databinding.jaxb.ClassNameAllocatorImpl;
import org.apache.cxf.tools.wsdlto.databinding.jaxb.JAXBBindErrorListener;
import org.apache.cxf.tools.wsdlto.databinding.jaxb.TypesCodeWriter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBDataBinding
implements DataBindingProfile {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBDataBinding.class);
    private S2JJAXBModel rawJaxbModelGenCode;
    private ToolContext context;

    private void initialize(ToolContext c) throws ToolException {
        this.context = c;
        SchemaCompilerImpl schemaCompiler = (SchemaCompilerImpl)XJC.createSchemaCompiler();
        ClassCollector classCollector = this.context.get(ClassCollector.class);
        ClassNameAllocatorImpl allocator = new ClassNameAllocatorImpl(classCollector);
        schemaCompiler.setClassNameAllocator((ClassNameAllocator)allocator);
        JAXBBindErrorListener listener = new JAXBBindErrorListener(this.context.isVerbose());
        schemaCompiler.setErrorListener((ErrorListener)listener);
        List<InputSource> jaxbBindings = this.context.getJaxbBindingFile();
        Map schemaLists = (Map)this.context.get("schemaMap");
        Set keys = schemaLists.keySet();
        for (String key : keys) {
            Element ele = (Element)schemaLists.get(key);
            this.removeImportElement(ele);
            String tns = ele.getAttribute("targetNamespace");
            if (StringUtils.isEmpty(tns)) continue;
            if (this.context.get("validate") != null) {
                this.validateSchema(ele);
            }
            schemaCompiler.parseSchema(key, ele);
        }
        for (InputSource binding : jaxbBindings) {
            schemaCompiler.parseSchema(binding);
        }
        Map<String, String> nsPkgMap = this.context.getNamespacePackageMap();
        for (String ns : nsPkgMap.keySet()) {
            File file = JAXBUtils.getPackageMappingSchemaBindingFile(ns, this.context.mapPackageName(ns));
            InputSource ins = new InputSource(file.toURI().toString());
            schemaCompiler.parseSchema(ins);
            FileUtils.delete(file);
        }
        if (this.context.getPackageName() != null) {
            schemaCompiler.setDefaultPackageName(this.context.getPackageName());
        }
        this.rawJaxbModelGenCode = schemaCompiler.bind();
        this.addedEnumClassToCollector(schemaLists, allocator);
    }

    private void addedEnumClassToCollector(Map<String, Element> schemaList, ClassNameAllocatorImpl allocator) {
        for (Element schemaElement : schemaList.values()) {
            String packageName;
            String targetNamespace = schemaElement.getAttribute("targetNamespace");
            if (StringUtils.isEmpty(targetNamespace) || this.addedToClassCollector(packageName = this.context.mapPackageName(targetNamespace))) continue;
            allocator.assignClassName(packageName, "*");
        }
    }

    private boolean addedToClassCollector(String packageName) {
        ClassCollector classCollector = this.context.get(ClassCollector.class);
        List<String> files = classCollector.getGeneratedFileInfo();
        for (String file : files) {
            int dotIndex;
            String sub = file.substring(0, (dotIndex = file.lastIndexOf(".")) - 1);
            if (!sub.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean isSuppressCodeGen() {
        return this.context.optionSet("suppress");
    }

    @Override
    public void generate(ToolContext c) throws ToolException {
        this.initialize(c);
        if (this.rawJaxbModelGenCode == null) {
            return;
        }
        try {
            String dir = (String)this.context.get("outputdir");
            TypesCodeWriter fileCodeWriter = new TypesCodeWriter(new File(dir), this.context.getExcludePkgList());
            if (this.rawJaxbModelGenCode instanceof S2JJAXBModel) {
                S2JJAXBModel schem2JavaJaxbModel = this.rawJaxbModelGenCode;
                JCodeModel jcodeModel = schem2JavaJaxbModel.generateCode(null, null);
                if (!this.isSuppressCodeGen()) {
                    jcodeModel.build((CodeWriter)fileCodeWriter);
                }
                this.context.put(JCodeModel.class, jcodeModel);
                for (String str : fileCodeWriter.getExcludeFileList()) {
                    this.context.getExcludeFileList().add(str);
                }
            }
            return;
        }
        catch (IOException e) {
            Message msg = new Message("FAIL_TO_GENERATE_TYPES", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    @Override
    public String getType(QName qname, boolean element) {
        Mapping mapping;
        TypeAndAnnotation typeAnno = this.rawJaxbModelGenCode.getJavaType(qname);
        if (element && (mapping = this.rawJaxbModelGenCode.get(qname)) != null) {
            typeAnno = mapping.getType();
        }
        if (typeAnno != null && typeAnno.getTypeClass() != null) {
            return typeAnno.getTypeClass().fullName();
        }
        return null;
    }

    @Override
    public String getWrappedElementType(QName wrapperElement, QName item) {
        Mapping mapping = this.rawJaxbModelGenCode.get(wrapperElement);
        if (mapping != null) {
            List propList = mapping.getWrapperStyleDrilldown();
            for (Property pro : propList) {
                if (!pro.elementName().getNamespaceURI().equals(item.getNamespaceURI()) || !pro.elementName().getLocalPart().equals(item.getLocalPart())) continue;
                return pro.type().fullName();
            }
        }
        return null;
    }

    private void removeImportElement(Element element) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        ArrayList<Node> ns = new ArrayList<Node>();
        for (int tmp = 0; tmp < nodeList.getLength(); ++tmp) {
            Node importNode = nodeList.item(tmp);
            ns.add(importNode);
        }
        for (Node item : ns) {
            Node schemaNode = item.getParentNode();
            schemaNode.removeChild(item);
        }
    }

    public Node cloneNode(Document document, Node node, boolean deep) throws DOMException {
        Node clone;
        if (document == null || node == null) {
            return null;
        }
        short type = node.getNodeType();
        if (node.getOwnerDocument() == document) {
            return node.cloneNode(deep);
        }
        switch (type) {
            case 4: {
                clone = document.createCDATASection(node.getNodeValue());
                break;
            }
            case 8: {
                clone = document.createComment(node.getNodeValue());
                break;
            }
            case 5: {
                clone = document.createEntityReference(node.getNodeName());
                break;
            }
            case 1: {
                clone = document.createElement(node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    ((Element)clone).setAttribute(attributes.item(i).getNodeName(), attributes.item(i).getNodeValue());
                }
                break;
            }
            case 3: {
                clone = document.createTextNode(node.getNodeValue());
                break;
            }
            default: {
                return null;
            }
        }
        if (deep && type == 1) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                clone.appendChild(this.cloneNode(document, child, true));
            }
        }
        return clone;
    }

    public void validateSchema(Element ele) throws ToolException {
        block2: {
            SchemaFactory schemaFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            DOMSource domSrc = new DOMSource(ele);
            try {
                schemaFact.newSchema(domSrc);
            }
            catch (SAXException e) {
                if (e.getLocalizedMessage().indexOf("src-resolve.4.2") > -1) break block2;
                throw new ToolException("Schema Error : " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

