/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Soap12FaultOutInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(Soap12FaultOutInterceptor.class);

    public Soap12FaultOutInterceptor() {
        super("prepare-send");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        message.put(Message.RESPONSE_CODE, (Object)new Integer(500));
        message.getInterceptorChain().add(Soap12FaultOutInterceptorInternal.INSTANCE);
    }

    static class Soap12FaultOutInterceptorInternal
    extends AbstractSoapInterceptor {
        static final Soap12FaultOutInterceptorInternal INSTANCE = new Soap12FaultOutInterceptorInternal();

        public Soap12FaultOutInterceptorInternal() {
            super("marshal");
        }

        public void handleMessage(SoapMessage message) throws Fault {
            LOG.info(this.getClass() + (String)message.get("Content-Type"));
            message.put(Message.RESPONSE_CODE, (Object)new Integer(500));
            XMLStreamWriter writer = message.getContent(XMLStreamWriter.class);
            Fault f = (Fault)message.getContent(Exception.class);
            SoapFault fault = SoapFault.createFault(f, message.getVersion());
            try {
                Map<String, String> namespaces = fault.getNamespaces();
                for (Map.Entry<String, String> e : namespaces.entrySet()) {
                    writer.writeNamespace(e.getKey(), e.getValue());
                }
                String ns = message.getVersion().getNamespace();
                String defaultPrefix = StaxUtils.getUniquePrefix(writer, ns, true);
                writer.writeStartElement(defaultPrefix, "Fault", ns);
                writer.writeStartElement(defaultPrefix, "Code", ns);
                writer.writeStartElement(defaultPrefix, "Value", ns);
                writer.writeCharacters(fault.getCodeString(this.getFaultCodePrefix(writer, fault.getFaultCode()), defaultPrefix));
                writer.writeEndElement();
                if (fault.getSubCode() != null) {
                    writer.writeStartElement(defaultPrefix, "Subcode", ns);
                    writer.writeStartElement(defaultPrefix, "Value", ns);
                    writer.writeCharacters(fault.getSubCodeString(this.getFaultCodePrefix(writer, fault.getSubCode()), defaultPrefix));
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                writer.writeStartElement(defaultPrefix, "Reason", ns);
                writer.writeStartElement(defaultPrefix, "Text", ns);
                writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang ", this.getLangCode());
                if (fault.getMessage() != null) {
                    writer.writeCharacters(fault.getMessage());
                } else {
                    writer.writeCharacters("Fault occurred while processing.");
                }
                writer.writeEndElement();
                writer.writeEndElement();
                if (fault.hasDetails()) {
                    Element detail = fault.getDetail();
                    writer.writeStartElement(defaultPrefix, "Detail", ns);
                    for (Node node = detail.getFirstChild(); node != null; node = node.getNextSibling()) {
                        StaxUtils.writeNode(node, writer, true);
                    }
                    writer.writeEndElement();
                }
                if (fault.getRole() != null) {
                    writer.writeStartElement("faultactor");
                    writer.writeCharacters(fault.getRole());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            catch (XMLStreamException xe) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", LOG, new Object[0]), (Throwable)xe);
            }
        }

        private String getLangCode() {
            String code = LOG.getResourceBundle().getLocale().getDisplayLanguage();
            if (StringUtils.isEmpty(code)) {
                return "en";
            }
            return code;
        }
    }
}

