/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.BindingProviderImpl;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsClientProxy
extends ClientProxy
implements InvocationHandler,
BindingProvider {
    public static final String THREAD_LOCAL_REQUEST_CONTEXT = "thread.local.request.context";
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsClientProxy.class);
    private final Binding binding;

    public JaxWsClientProxy(Client c, Binding b) {
        super(c);
        this.binding = b;
        this.setupEndpointAddressContext(this.getClient().getEndpoint());
    }

    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            this.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Endpoint endpoint = this.getClient().getEndpoint();
        String address = endpoint.getEndpointInfo().getAddress();
        MethodDispatcher dispatcher = (MethodDispatcher)endpoint.getService().get(MethodDispatcher.class.getName());
        BindingOperationInfo oi = dispatcher.getBindingOperation(method, endpoint);
        if (oi == null) {
            if (method.getDeclaringClass().equals(BindingProvider.class) || method.getDeclaringClass().equals(BindingProviderImpl.class) || method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, new Object[0]);
            }
            Message msg = new Message("NO_BINDING_OPERATION_INFO", LOG, method.getName());
            throw new WebServiceException(msg.toString());
        }
        this.client.getRequestContext().put(Method.class.getName(), method);
        boolean isAsync = method.getName().endsWith("Async");
        ContextPropertiesMapping.mapRequestfromJaxws2Cxf(this.client.getRequestContext());
        Object result = null;
        try {
            result = isAsync ? this.invokeAsync(method, oi, args) : this.invokeSync(method, oi, args);
        }
        catch (WebServiceException wex) {
            throw wex.fillInStackTrace();
        }
        catch (Exception ex) {
            for (Class<?> excls : method.getExceptionTypes()) {
                if (!excls.isInstance(ex)) continue;
                throw ex.fillInStackTrace();
            }
            if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)ex);
                throw exception;
            }
            if (this.getBinding() instanceof SOAPBinding) {
                SOAPFault soapFault = this.createSoapFault(ex);
                if (soapFault == null) {
                    throw new WebServiceException((Throwable)ex);
                }
                SOAPFaultException exception = new SOAPFaultException(soapFault);
                exception.initCause((Throwable)ex);
                throw exception;
            }
            throw new WebServiceException((Throwable)ex);
        }
        finally {
            if (this.addressChanged(address)) {
                this.setupEndpointAddressContext(this.getClient().getEndpoint());
            }
        }
        ContextPropertiesMapping.mapResponsefromCxf2Jaxws(this.client.getResponseContext());
        Map scopes = CastUtils.cast((Map)this.client.getResponseContext().get(WrappedMessageContext.SCOPES));
        if (scopes != null) {
            for (Map.Entry scope : scopes.entrySet()) {
                if (scope.getValue() != MessageContext.Scope.HANDLER) continue;
                this.client.getResponseContext().remove(scope.getKey());
            }
        }
        return result;
    }

    private SOAPFault createSoapFault(Exception ex) throws SOAPException {
        SOAPFault soapFault;
        try {
            soapFault = ((SOAPBinding)this.getBinding()).getSOAPFactory().createFault();
        }
        catch (Throwable t) {
            try {
                soapFault = ((SOAPBinding)this.getBinding()).getMessageFactory().createMessage().getSOAPBody().addFault();
            }
            catch (Throwable t2) {
                return null;
            }
        }
        if (ex instanceof SoapFault) {
            soapFault.setFaultString(((SoapFault)ex).getReason());
            soapFault.setFaultCode(((SoapFault)ex).getFaultCode());
            soapFault.setFaultActor(((SoapFault)ex).getRole());
            Node nd = soapFault.getOwnerDocument().importNode(((SoapFault)ex).getOrCreateDetail(), true);
            nd = nd.getFirstChild();
            soapFault.addDetail();
            while (nd != null) {
                Node next = nd.getNextSibling();
                soapFault.getDetail().appendChild(nd);
                nd = next;
            }
        } else {
            String msg = ex.getMessage();
            if (msg != null) {
                soapFault.setFaultString(msg);
            }
        }
        return soapFault;
    }

    private boolean addressChanged(String address) {
        return address != null && this.getClient().getEndpoint().getEndpointInfo() != null && !address.equals(this.getClient().getEndpoint().getEndpointInfo().getAddress());
    }

    private Object invokeAsync(Method method, BindingOperationInfo oi, Object[] params) throws Exception {
        this.client.setExecutor(this.getClient().getEndpoint().getExecutor());
        AsyncHandler handler = params.length > 0 && params[params.length - 1] instanceof AsyncHandler ? (AsyncHandler)params[params.length - 1] : null;
        JaxwsClientCallback callback = new JaxwsClientCallback(handler);
        ResponseCallback ret = new ResponseCallback(callback);
        this.client.invoke((ClientCallback)callback, oi, params);
        return ret;
    }

    @Override
    public Map<String, Object> getRequestContext() {
        return new WrappedMessageContext(this.getClient().getRequestContext(), null, MessageContext.Scope.APPLICATION);
    }

    @Override
    public Map<String, Object> getResponseContext() {
        return new WrappedMessageContext(this.getClient().getResponseContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Binding getBinding() {
        return this.binding;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResponseCallback
    implements Response<Object> {
        ClientCallback callback;

        public ResponseCallback(ClientCallback cb) {
            this.callback = cb;
        }

        public Map<String, Object> getContext() {
            try {
                return this.callback.getResponseContext();
            }
            catch (Exception ex) {
                return null;
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.callback.cancel(mayInterruptIfRunning);
        }

        public Object get() throws InterruptedException, ExecutionException {
            return this.callback.get()[0];
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.callback.get(timeout, unit)[0];
        }

        public boolean isCancelled() {
            return this.callback.isCancelled();
        }

        public boolean isDone() {
            return this.callback.isDone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JaxwsClientCallback
    extends ClientCallback {
        final AsyncHandler<Object> handler;

        public JaxwsClientCallback(AsyncHandler<Object> handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResponse(Map<String, Object> ctx, Object[] res) {
            this.context = ctx;
            this.result = res;
            if (this.handler != null) {
                this.handler.handleResponse((Response)new Response<Object>(){

                    public Map<String, Object> getContext() {
                        return JaxwsClientCallback.this.context;
                    }

                    public boolean cancel(boolean mayInterruptIfRunning) {
                        JaxwsClientCallback.this.cancelled = true;
                        return true;
                    }

                    public Object get() throws InterruptedException, ExecutionException {
                        return JaxwsClientCallback.this.result[0];
                    }

                    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return JaxwsClientCallback.this.result[0];
                    }

                    public boolean isCancelled() {
                        return JaxwsClientCallback.this.cancelled;
                    }

                    public boolean isDone() {
                        return true;
                    }
                });
            }
            this.done = true;
            JaxwsClientCallback jaxwsClientCallback = this;
            synchronized (jaxwsClientCallback) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleException(Map<String, Object> ctx, final Throwable ex) {
            this.context = ctx;
            this.exception = ex;
            if (this.handler != null) {
                this.handler.handleResponse((Response)new Response<Object>(){

                    public Map<String, Object> getContext() {
                        return JaxwsClientCallback.this.context;
                    }

                    public boolean cancel(boolean mayInterruptIfRunning) {
                        JaxwsClientCallback.this.cancelled = true;
                        return true;
                    }

                    public Object get() throws InterruptedException, ExecutionException {
                        throw new ExecutionException(ex);
                    }

                    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        throw new ExecutionException(ex);
                    }

                    public boolean isCancelled() {
                        return JaxwsClientCallback.this.cancelled;
                    }

                    public boolean isDone() {
                        return true;
                    }
                });
            }
            this.done = true;
            JaxwsClientCallback jaxwsClientCallback = this;
            synchronized (jaxwsClientCallback) {
                this.notifyAll();
            }
        }
    }
}

