/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.io.IOException;
import java.net.URL;
import org.apache.cxf.bus.spring.TunedDocumentLoader;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.DocumentLoader;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public class ControlledValidationXmlBeanDefinitionReader
extends XmlBeanDefinitionReader {
    private int visibleValidationMode = 1;

    public ControlledValidationXmlBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        super(beanFactory);
        this.setDocumentLoader((DocumentLoader)new TunedDocumentLoader());
    }

    protected int doLoadBeanDefinitions(InputSource inputSource, Resource resource) throws BeanDefinitionStoreException {
        boolean suppressValidation = false;
        try {
            URL url = resource.getURL();
            if (url.getFile().contains("META-INF/cxf/")) {
                suppressValidation = true;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        int savedValidation = this.visibleValidationMode;
        if (suppressValidation) {
            this.setValidationMode(0);
        }
        int r = super.doLoadBeanDefinitions(inputSource, resource);
        this.setValidationMode(savedValidation);
        return r;
    }

    public void setValidationMode(int validationMode) {
        this.visibleValidationMode = validationMode;
        super.setValidationMode(validationMode);
    }
}

