/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ClassNameProcessor;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.wsdlto.core.WSDLToProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.PortTypeProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ServiceProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.BindingAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WebServiceAnnotator;

public class WSDLToJavaProcessor
extends WSDLToProcessor
implements ClassNameProcessor {
    private static final String MODEL_MAP = WSDLToProcessor.class.getName() + ".MODEL_MAP";

    public void processClassNames() {
        ServiceInfo serviceInfo = this.context.get(ServiceInfo.class);
        PortTypeProcessor portTypeProcessor = new PortTypeProcessor(this.context);
        portTypeProcessor.processClassNames(serviceInfo);
    }

    public void process() throws ToolException {
        super.process();
        JavaModel jmodel = this.wsdlDefinitionToJavaModel(this.context.get(ServiceInfo.class));
        if (jmodel == null) {
            Message msg = new Message("FAIL_TO_CREATE_JAVA_MODEL", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        this.context.setJavaModel(jmodel);
    }

    private JavaModel wsdlDefinitionToJavaModel(ServiceInfo serviceInfo) throws ToolException {
        JavaModel javaModel = null;
        Map map = CastUtils.cast((Map)this.context.get(MODEL_MAP));
        if (map == null) {
            map = new HashMap();
            this.context.put(MODEL_MAP, map);
        }
        if (map.containsKey(serviceInfo.getName())) {
            javaModel = (JavaModel)map.get(serviceInfo.getName());
        } else {
            javaModel = new JavaModel();
            map.put(serviceInfo.getName(), javaModel);
        }
        this.context.put(JavaModel.class, javaModel);
        ArrayList<JavaInterface> interfaces = new ArrayList<JavaInterface>();
        interfaces.addAll(javaModel.getInterfaces().values());
        PortTypeProcessor portTypeProcessor = new PortTypeProcessor(this.context);
        portTypeProcessor.process(serviceInfo);
        ServiceProcessor serviceProcessor = new ServiceProcessor(this.context);
        serviceProcessor.process(serviceInfo);
        for (JavaInterface intf : javaModel.getInterfaces().values()) {
            if (interfaces.contains(intf)) continue;
            intf.annotate(new WebServiceAnnotator());
            intf.annotate(new BindingAnnotator());
        }
        return javaModel;
    }
}

