/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty.spring;

import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.jsse.spring.TLSServerParametersConfig;
import org.apache.cxf.configuration.security.TLSServerParametersType;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transport.http_jetty.spring.JAXBHelper;
import org.apache.cxf.transports.http_jetty.configuration.TLSServerParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersType;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class JettyHTTPServerEngineBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    public void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        String portStr = element.getAttribute("port");
        int port = Integer.valueOf(portStr);
        bean.addPropertyValue("port", (Object)port);
        String continuationsStr = element.getAttribute("continuationsEnabled");
        if (continuationsStr != null && continuationsStr.length() > 0) {
            bean.addPropertyValue("continuationsEnabled", (Object)Boolean.parseBoolean(continuationsStr));
        }
        MutablePropertyValues engineFactoryProperties = ctx.getContainingBeanDefinition().getPropertyValues();
        PropertyValue busValue = engineFactoryProperties.getPropertyValue("bus");
        try {
            Element elem = DOMUtils.getFirstElement(element);
            while (elem != null) {
                Object param;
                Object parametersType;
                String name = elem.getLocalName();
                if ("tlsServerParameters".equals(name)) {
                    parametersType = JAXBHelper.parseElement(elem, bean, TLSServerParametersType.class);
                    param = new TLSServerParametersConfig((TLSServerParametersType)parametersType);
                    bean.addPropertyValue("tlsServerParameters", param);
                } else if ("tlsServerParametersRef".equals(name)) {
                    TLSServerParametersIdentifiedType parameterTypeRef = JAXBHelper.parseElement(elem, bean, TLSServerParametersIdentifiedType.class);
                    param = this.getTlsServerParameters(engineFactoryProperties, parameterTypeRef.getId());
                    bean.addPropertyValue("tlsServerParameters", param);
                } else if ("threadingParameters".equals(name)) {
                    parametersType = JAXBHelper.parseElement(elem, bean, ThreadingParametersType.class);
                    param = this.toThreadingParameters((ThreadingParametersType)parametersType);
                    bean.addPropertyValue("threadingParameters", param);
                } else if ("threadingParametersRef".equals(name)) {
                    ThreadingParametersIdentifiedType parametersTypeRef = JAXBHelper.parseElement(elem, bean, ThreadingParametersIdentifiedType.class);
                    param = this.getThreadingParameters(engineFactoryProperties, parametersTypeRef.getId());
                    bean.addPropertyValue("threadingParameters", param);
                } else if ("connector".equals(name)) {
                    List list = ctx.getDelegate().parseListElement(elem, (BeanDefinition)bean.getBeanDefinition());
                    bean.addPropertyValue("connector", list.get(0));
                } else if ("handlers".equals(name)) {
                    List handlers = ctx.getDelegate().parseListElement(elem, (BeanDefinition)bean.getBeanDefinition());
                    bean.addPropertyValue("handlers", (Object)handlers);
                } else if ("sessionSupport".equals(name) || "reuseAddress".equals(name)) {
                    String text = elem.getTextContent();
                    bean.addPropertyValue(name, (Object)Boolean.valueOf(text));
                }
                elem = DOMUtils.getNextElement(elem);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process configuration.", e);
        }
        if (ctx.getContainingBeanDefinition().getAttribute(WIRE_BUS_ATTRIBUTE) == BusWiringType.PROPERTY) {
            this.addBusWiringAttribute(bean, BusWiringType.PROPERTY);
        } else {
            bean.addPropertyValue("bus", busValue.getValue());
        }
        bean.setLazyInit(false);
    }

    private TLSServerParameters getTlsServerParameters(MutablePropertyValues engineFactoryProperties, String reference) {
        TLSServerParameters result = null;
        PropertyValue tlsParameterMapValue = engineFactoryProperties.getPropertyValue("tlsServerParametersMap");
        if (null == tlsParameterMapValue) {
            throw new RuntimeException("Could not find the tlsServerParametersMap from the JettyHTTPServerEngineFactory!");
        }
        Map tlsServerParametersMap = (Map)tlsParameterMapValue.getValue();
        result = (TLSServerParameters)tlsServerParametersMap.get(reference);
        if (result == null) {
            throw new RuntimeException("Could not find the tlsServerParametersMap reference [" + reference + "]'s mapping tlsParameter");
        }
        return result;
    }

    private ThreadingParameters getThreadingParameters(MutablePropertyValues engineFactoryProperties, String reference) {
        ThreadingParameters result = null;
        PropertyValue threadingParametersMapValue = engineFactoryProperties.getPropertyValue("threadingParametersMap");
        if (null == threadingParametersMapValue) {
            throw new RuntimeException("Could not find the threadingParametersMap from the JettyHTTPServerEngineFactory!");
        }
        Map threadingParametersMap = (Map)threadingParametersMapValue.getValue();
        result = (ThreadingParameters)threadingParametersMap.get(reference);
        if (result == null) {
            throw new RuntimeException("Could not find the threadingParametersMap reference [" + reference + "]'s mapping threadingParameters");
        }
        return result;
    }

    private ThreadingParameters toThreadingParameters(ThreadingParametersType paramtype) {
        ThreadingParameters params = new ThreadingParameters();
        params.setMaxThreads(paramtype.getMaxThreads());
        params.setMinThreads(paramtype.getMinThreads());
        return params;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected Class getBeanClass(Element arg0) {
        return JettyHTTPServerEngine.class;
    }

    public static class SpringJettyHTTPServerEngine
    extends JettyHTTPServerEngine
    implements ApplicationContextAware {
        public SpringJettyHTTPServerEngine(JettyHTTPServerEngineFactory fac, Bus bus, int port) {
            super(fac, bus, port);
        }

        public SpringJettyHTTPServerEngine() {
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.getBus() == null) {
                Bus bus = BusFactory.getThreadDefaultBus();
                BusWiringBeanFactoryPostProcessor.updateBusReferencesInContext(bus, ctx);
                this.setBus(bus);
            }
        }
    }
}

