/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.CXFBusImpl;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class SpringBusFactory
extends BusFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(SpringBusFactory.class);
    private final ApplicationContext context;

    public SpringBusFactory() {
        this.context = null;
    }

    public SpringBusFactory(ApplicationContext context) {
        this.context = context;
    }

    public Bus createBus() {
        return this.createBus((String)null);
    }

    private boolean defaultBusNotExists() {
        if (null != this.context) {
            this.context.containsBean("cxf");
            return false;
        }
        return true;
    }

    public Bus createBus(String cfgFile) {
        return this.createBus(cfgFile, this.defaultBusNotExists());
    }

    private Bus finishCreatingBus(BusApplicationContext bac) {
        Bus bus = (Bus)bac.getBean("cxf");
        bus.setExtension(new ConfigurerImpl((ApplicationContext)bac), Configurer.class);
        bus.setExtension(bac, BusApplicationContext.class);
        SpringBusFactory.possiblySetDefaultBus(bus);
        this.initializeBus(bus);
        this.registerApplicationContextLifeCycleListener(bus, bac);
        return bus;
    }

    public Bus createBus(String cfgFile, boolean includeDefaults) {
        try {
            return this.finishCreatingBus(new BusApplicationContext(cfgFile, includeDefaults, this.context));
        }
        catch (BeansException ex) {
            LogUtils.log(LOG, Level.WARNING, "APP_CONTEXT_CREATION_FAILED_MSG", (Throwable)ex, (Object[])null);
            throw new RuntimeException(ex);
        }
    }

    public Bus createBus(URL url) {
        return this.createBus(url, this.defaultBusNotExists());
    }

    public Bus createBus(URL url, boolean includeDefaults) {
        try {
            return this.finishCreatingBus(new BusApplicationContext(url, includeDefaults, this.context));
        }
        catch (BeansException ex) {
            LogUtils.log(LOG, Level.WARNING, "APP_CONTEXT_CREATION_FAILED_MSG", (Throwable)ex, (Object[])null);
            throw new RuntimeException(ex);
        }
    }

    protected void initializeBus(Bus bus) {
        ((CXFBusImpl)bus).initialize();
        super.initializeBus(bus);
    }

    void registerApplicationContextLifeCycleListener(Bus bus, BusApplicationContext bac) {
        BusLifeCycleManager lm = bus.getExtension(BusLifeCycleManager.class);
        if (null != lm) {
            lm.registerLifeCycleListener(new BusApplicationContextLifeCycleListener(bac));
        }
    }

    static class BusApplicationContextLifeCycleListener
    implements BusLifeCycleListener {
        private BusApplicationContext bac;

        BusApplicationContextLifeCycleListener(BusApplicationContext b) {
            this.bac = b;
        }

        public void initComplete() {
        }

        public void preShutdown() {
        }

        public void postShutdown() {
            this.bac.close();
        }
    }
}

