/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogRecord;
import org.apache.cxf.common.logging.AbstractDelegatingLogger;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLogger
extends AbstractDelegatingLogger {
    private static final Map<java.util.logging.Level, Level> TO_LOG4J = new HashMap<java.util.logging.Level, Level>();
    private static final Map<Level, java.util.logging.Level> FROM_LOG4J = new HashMap<Level, java.util.logging.Level>();
    private Logger log;

    public Log4jLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.log = LogManager.getLogger((String)name);
    }

    public java.util.logging.Level getLevel() {
        for (Logger c = this.log; c != null; c = c.getParent()) {
            Level l = c.getLevel();
            if (l == null) continue;
            return FROM_LOG4J.get(l);
        }
        return null;
    }

    protected void internalLogFormatted(String msg, LogRecord record) {
        this.log.log(AbstractDelegatingLogger.class.getName(), (Priority)TO_LOG4J.get(record.getLevel()), (Object)msg, record.getThrown());
    }

    static {
        TO_LOG4J.put(java.util.logging.Level.ALL, Level.ALL);
        TO_LOG4J.put(java.util.logging.Level.SEVERE, Level.ERROR);
        TO_LOG4J.put(java.util.logging.Level.WARNING, Level.WARN);
        TO_LOG4J.put(java.util.logging.Level.INFO, Level.INFO);
        TO_LOG4J.put(java.util.logging.Level.CONFIG, Level.DEBUG);
        TO_LOG4J.put(java.util.logging.Level.FINE, Level.DEBUG);
        TO_LOG4J.put(java.util.logging.Level.FINER, Level.TRACE);
        TO_LOG4J.put(java.util.logging.Level.FINEST, Level.TRACE);
        TO_LOG4J.put(java.util.logging.Level.OFF, Level.OFF);
        FROM_LOG4J.put(Level.ALL, java.util.logging.Level.ALL);
        FROM_LOG4J.put(Level.ERROR, java.util.logging.Level.SEVERE);
        FROM_LOG4J.put(Level.WARN, java.util.logging.Level.WARNING);
        FROM_LOG4J.put(Level.INFO, java.util.logging.Level.INFO);
        FROM_LOG4J.put(Level.DEBUG, java.util.logging.Level.FINE);
        FROM_LOG4J.put(Level.TRACE, java.util.logging.Level.FINEST);
        FROM_LOG4J.put(Level.OFF, java.util.logging.Level.OFF);
    }
}

