/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.binding.soap.SoapBindingConfiguration;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.interceptor.AnnotationInterceptors;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndpointFactory
extends AbstractBasicInterceptorProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractEndpointFactory.class);
    private Bus bus;
    private String address;
    private String transportId;
    private String bindingId;
    private Class serviceClass;
    private DataBinding dataBinding;
    private BindingFactory bindingFactory;
    private DestinationFactory destinationFactory;
    private ReflectionServiceFactoryBean serviceFactory;
    private QName endpointName;
    private QName serviceName;
    private Map<String, Object> properties;
    private List<AbstractFeature> features;
    private BindingConfiguration bindingConfig;
    private EndpointReferenceType endpointReference;
    private ConduitSelector conduitSelector;

    protected Endpoint createEndpoint() throws BusException, EndpointException {
        Endpoint ep;
        EndpointInfo ei;
        Service service = this.serviceFactory.getService();
        if (service == null) {
            this.initializeServiceFactory();
            service = this.serviceFactory.create();
        }
        if (this.serviceName != null) {
            this.serviceFactory.setServiceName(this.serviceName);
        }
        if (this.endpointName == null) {
            this.endpointName = this.serviceFactory.getEndpointName();
        }
        if ((ei = service.getEndpointInfo(this.endpointName)) != null) {
            if (this.transportId != null && !ei.getTransportId().equals(this.transportId)) {
                ei = null;
            } else {
                BindingFactoryManager bfm = this.getBus().getExtension(BindingFactoryManager.class);
                this.bindingFactory = bfm.getBindingFactory(ei.getBinding().getBindingId());
            }
        }
        if (ei == null) {
            if (this.getAddress() == null) {
                ei = ServiceModelUtil.findBestEndpointInfo(this.serviceFactory.getInterfaceName(), service.getServiceInfos());
            }
            if (ei == null) {
                ei = this.createEndpointInfo();
            }
        } else if (this.getAddress() != null) {
            ei.setAddress(this.getAddress());
        }
        if (this.endpointReference != null) {
            ei.setAddress(this.endpointReference);
        }
        if ((ep = service.getEndpoints().get(ei.getName())) == null) {
            ep = this.serviceFactory.createEndpoint(ei);
            ((EndpointImpl)ep).initializeActiveFeatures(this.getFeatures());
        } else {
            this.serviceFactory.setEndpointName(ei.getName());
            if (ep.getActiveFeatures() == null) {
                ((EndpointImpl)ep).initializeActiveFeatures(this.getFeatures());
            }
        }
        if (this.properties != null) {
            ep.putAll(this.properties);
        }
        service.getEndpoints().put(ep.getEndpointInfo().getName(), ep);
        if (this.getInInterceptors() != null) {
            ep.getInInterceptors().addAll(this.getInInterceptors());
        }
        if (this.getOutInterceptors() != null) {
            ep.getOutInterceptors().addAll(this.getOutInterceptors());
        }
        if (this.getInFaultInterceptors() != null) {
            ep.getInFaultInterceptors().addAll(this.getInFaultInterceptors());
        }
        if (this.getOutFaultInterceptors() != null) {
            ep.getOutFaultInterceptors().addAll(this.getOutFaultInterceptors());
        }
        return ep;
    }

    protected void initializeServiceFactory() {
        Class cls = this.getServiceClass();
        this.serviceFactory.setServiceClass(cls);
        this.serviceFactory.setBus(this.getBus());
        if (this.dataBinding != null) {
            this.serviceFactory.setDataBinding(this.dataBinding);
        }
    }

    protected EndpointInfo createEndpointInfo() throws BusException {
        EndpointInfo ei;
        if (this.transportId == null && this.getAddress() != null) {
            DestinationFactory df = this.getDestinationFactory();
            if (df == null) {
                DestinationFactoryManager dfm = this.getBus().getExtension(DestinationFactoryManager.class);
                df = dfm.getDestinationFactoryForUri(this.getAddress());
            }
            if (df != null) {
                this.transportId = df.getTransportIds().get(0);
            }
        }
        Service service = this.serviceFactory.getService();
        BindingInfo bindingInfo = this.createBindingInfo();
        if (bindingInfo instanceof SoapBindingInfo && (((SoapBindingInfo)bindingInfo).getTransportURI() == null || "http://cxf.apache.org/transports/local".equals(this.transportId))) {
            ((SoapBindingInfo)bindingInfo).setTransportURI(this.transportId);
            this.transportId = "http://schemas.xmlsoap.org/wsdl/soap/";
        }
        if (this.transportId == null) {
            this.transportId = bindingInfo instanceof SoapBindingInfo ? "http://schemas.xmlsoap.org/wsdl/soap/" : "http://schemas.xmlsoap.org/wsdl/http/";
        }
        service.getServiceInfos().get(0).addBinding(bindingInfo);
        this.setTransportId(this.transportId);
        if (this.destinationFactory == null) {
            DestinationFactoryManager dfm = this.getBus().getExtension(DestinationFactoryManager.class);
            this.destinationFactory = dfm.getDestinationFactory(this.transportId);
        }
        if (this.destinationFactory instanceof WSDLEndpointFactory) {
            ei = ((WSDLEndpointFactory)((Object)this.destinationFactory)).createEndpointInfo(service.getServiceInfos().get(0), bindingInfo, null);
            ei.setTransportId(this.transportId);
        } else {
            ei = new EndpointInfo(service.getServiceInfos().get(0), this.transportId);
        }
        int count = 1;
        while (service.getEndpointInfo(this.endpointName) != null) {
            this.endpointName = new QName(this.endpointName.getNamespaceURI(), this.endpointName.getLocalPart() + count);
            ++count;
        }
        ei.setName(this.endpointName);
        ei.setAddress(this.getAddress());
        ei.setBinding(bindingInfo);
        if (this.destinationFactory instanceof WSDLEndpointFactory) {
            WSDLEndpointFactory we = (WSDLEndpointFactory)((Object)this.destinationFactory);
            we.createPortExtensors(ei, service);
        }
        service.getServiceInfos().get(0).addEndpoint(ei);
        return ei;
    }

    protected void initializeAnnotationInterceptors(Endpoint ep, Class<?> cls) {
        AnnotationInterceptors provider = new AnnotationInterceptors(cls);
        if (this.initializeAnnotationInterceptors(provider, ep)) {
            LOG.fine("Added annotation based interceptors and features");
        }
    }

    protected boolean initializeAnnotationInterceptors(AnnotationInterceptors provider, Endpoint ep) {
        boolean hasAnnotation = false;
        if (provider.getInFaultInterceptors() != null) {
            ep.getInFaultInterceptors().addAll(provider.getInFaultInterceptors());
            hasAnnotation = true;
        }
        if (provider.getInInterceptors() != null) {
            ep.getInInterceptors().addAll(provider.getInInterceptors());
            hasAnnotation = true;
        }
        if (provider.getOutFaultInterceptors() != null) {
            ep.getOutFaultInterceptors().addAll(provider.getOutFaultInterceptors());
            hasAnnotation = true;
        }
        if (provider.getOutInterceptors() != null) {
            ep.getOutInterceptors().addAll(provider.getOutInterceptors());
            hasAnnotation = true;
        }
        if (provider.getFeatures() != null) {
            this.getFeatures().addAll(provider.getFeatures());
            hasAnnotation = true;
        }
        return hasAnnotation;
    }

    protected BindingInfo createBindingInfo() {
        BindingFactoryManager mgr = this.bus.getExtension(BindingFactoryManager.class);
        String binding = this.bindingId;
        if (binding == null && this.bindingConfig != null) {
            binding = this.bindingConfig.getBindingId();
        }
        if (binding == null) {
            binding = "http://schemas.xmlsoap.org/soap/";
        }
        try {
            if ("http://schemas.xmlsoap.org/soap/".equals(binding)) {
                if (this.bindingConfig == null) {
                    this.bindingConfig = new SoapBindingConfiguration();
                }
                if (this.bindingConfig instanceof SoapBindingConfiguration) {
                    ((SoapBindingConfiguration)this.bindingConfig).setStyle(this.serviceFactory.getStyle());
                }
            }
            this.bindingFactory = mgr.getBindingFactory(binding);
            return this.bindingFactory.createBindingInfo(this.serviceFactory.getService(), binding, this.bindingConfig);
        }
        catch (BusException ex) {
            throw new ServiceConstructionException(new Message("COULD.NOT.RESOLVE.BINDING", LOG, this.bindingId), (Throwable)ex);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = BusFactory.getThreadDefaultBus();
        }
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public String getTransportId() {
        return this.transportId;
    }

    public void setTransportId(String transportId) {
        this.transportId = transportId;
    }

    public void setBindingId(String bind) {
        this.bindingId = bind;
    }

    public String getBindingId() {
        return this.bindingId;
    }

    public void setBindingConfig(BindingConfiguration obj) {
        this.bindingConfig = obj;
    }

    public BindingConfiguration getBindingConfig() {
        return this.bindingConfig;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public DestinationFactory getDestinationFactory() {
        return this.destinationFactory;
    }

    public void setDestinationFactory(DestinationFactory destinationFactory) {
        this.destinationFactory = destinationFactory;
    }

    public ReflectionServiceFactoryBean getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(ReflectionServiceFactoryBean serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public void setServiceName(QName name) {
        this.serviceName = name;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public QName getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(QName endpointName) {
        this.endpointName = endpointName;
    }

    public void setEndpointReference(EndpointReferenceType epr) {
        this.endpointReference = epr;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public List<AbstractFeature> getFeatures() {
        if (this.features == null) {
            this.features = new ArrayList<AbstractFeature>();
        }
        return this.features;
    }

    public void setFeatures(List<AbstractFeature> features) {
        this.features = features;
    }

    public String getWsdlURL() {
        return this.getServiceFactory().getWsdlURL();
    }

    public void setWsdlURL(String wsdlURL) {
        this.getServiceFactory().setWsdlURL(wsdlURL);
    }

    public BindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    public ConduitSelector getConduitSelector() {
        return this.conduitSelector;
    }

    public void setConduitSelector(ConduitSelector selector) {
        this.conduitSelector = selector;
    }

    public DataBinding getDataBinding() {
        return this.dataBinding;
    }

    public void setDataBinding(DataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }
}

