/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, 4096);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int avail = input.available();
        if (avail > 262144) {
            avail = 262144;
        }
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        return total;
    }

    public static void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        n = input.read(buffer);
        while (-1 != n) {
            output.write(buffer, 0, n);
            n = input.read(buffer);
        }
    }

    public static String toString(InputStream input) throws IOException {
        StringBuffer buf = new StringBuffer();
        byte[] buffer = new byte[4096];
        int n = 0;
        n = input.read(buffer);
        while (-1 != n) {
            buf.append(new String(buffer, 0, n));
            n = input.read(buffer);
        }
        return buf.toString();
    }

    public static String toString(Reader input) throws IOException {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[4096];
        int n = 0;
        n = input.read(buffer);
        while (-1 != n) {
            buf.append(new String(buffer, 0, n));
            n = input.read(buffer);
        }
        return buf.toString();
    }

    public static String readStringFromStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        int i = in.read();
        while (i != -1) {
            sb.append((char)i);
            i = in.read();
        }
        in.close();
        return sb.toString();
    }

    public static byte[] readBytesFromStream(InputStream in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        int i = in.read();
        while (i != -1) {
            bos.write(i);
            i = in.read();
        }
        in.close();
        return bos.toByteArray();
    }
}

