/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.logging.LogUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLUtils.class);
    private static DocumentBuilderFactory parserFactory;
    private static TransformerFactory transformerFactory;
    private static String omitXmlDecl;
    private static String charset;
    private static int indent;

    private XMLUtils() {
    }

    public static Transformer newTransformer() throws TransformerConfigurationException {
        return transformerFactory.newTransformer();
    }

    public static DocumentBuilder getParser() throws ParserConfigurationException {
        return parserFactory.newDocumentBuilder();
    }

    public static Document parse(InputSource is) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.getParser().parse(is.getSystemId());
    }

    public static Document parse(File is) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.getParser().parse(is);
    }

    public static Document parse(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        if (in == null && LOG.isLoggable(Level.FINE)) {
            LOG.fine("XMLUtils trying to parse a null inputstream");
        }
        return XMLUtils.getParser().parse(in);
    }

    public static Document parse(String in) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.parse(in.getBytes());
    }

    public static Document parse(byte[] in) throws ParserConfigurationException, SAXException, IOException {
        if (in == null && LOG.isLoggable(Level.FINE)) {
            LOG.fine("XMLUtils trying to parse a null bytes");
        }
        return XMLUtils.getParser().parse(new ByteArrayInputStream(in));
    }

    public static Document newDocument() throws ParserConfigurationException {
        return XMLUtils.getParser().newDocument();
    }

    public static void setOmitXmlDecl(String value) {
        omitXmlDecl = value;
    }

    public static void setCharsetEncoding(String value) {
        charset = value;
    }

    public static void setIndention(int i) {
        indent = i;
    }

    private static boolean indent() {
        return indent != -1;
    }

    public static void writeTo(Node node, OutputStream os) {
        XMLUtils.writeTo(new DOMSource(node), os);
    }

    public static void writeTo(Source src, OutputStream os) {
        try {
            Transformer it = XMLUtils.newTransformer();
            it.setOutputProperty("method", "xml");
            if (XMLUtils.indent()) {
                it.setOutputProperty("indent", "yes");
                it.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
            }
            it.setOutputProperty("omit-xml-declaration", omitXmlDecl);
            it.setOutputProperty("encoding", charset);
            it.transform(src, new StreamResult(os));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static String toString(Source source) throws TransformerException, IOException {
        return XMLUtils.toString(source, null);
    }

    public static String toString(Source source, Properties props) throws TransformerException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult sr = new StreamResult(bos);
        Transformer trans = XMLUtils.newTransformer();
        if (props == null) {
            props = new Properties();
            props.put("omit-xml-declaration", "yes");
        }
        trans.setOutputProperties(props);
        trans.transform(source, sr);
        bos.close();
        return bos.toString();
    }

    public static String toString(Node node) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLUtils.writeTo(node, (OutputStream)out);
        return out.toString();
    }

    public static void printDOM(Node node) {
        XMLUtils.printDOM("", node);
    }

    public static void printDOM(String words, Node node) {
        System.out.println(words);
        System.out.println(XMLUtils.toString(node));
    }

    public static Attr getAttribute(Element el, String attrName) {
        return el.getAttributeNode(attrName);
    }

    public static void replaceAttribute(Element element, String attr, String value) {
        if (element.hasAttribute(attr)) {
            element.removeAttribute(attr);
        }
        element.setAttribute(attr, value);
    }

    public static boolean hasAttribute(Element element, String value) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            if (!value.equals(node.getNodeValue())) continue;
            return true;
        }
        return false;
    }

    public static void printAttributes(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            System.err.println("## prefix=" + node.getPrefix() + " localname:" + node.getLocalName() + " value=" + node.getNodeValue());
        }
    }

    public static QName getNamespace(Map<String, String> namespaces, String str, String defaultNamespace) {
        String prefix = null;
        String localName = null;
        StringTokenizer tokenizer = new StringTokenizer(str, ":");
        if (tokenizer.countTokens() == 2) {
            prefix = tokenizer.nextToken();
            localName = tokenizer.nextToken();
        } else if (tokenizer.countTokens() == 1) {
            localName = tokenizer.nextToken();
        }
        String namespceURI = defaultNamespace;
        if (prefix != null) {
            namespceURI = namespaces.get(prefix);
        }
        return new QName(namespceURI, localName);
    }

    public static void generateXMLFile(Element element, Writer writer) {
        try {
            Transformer it = XMLUtils.newTransformer();
            it.setOutputProperty("method", "xml");
            it.setOutputProperty("indent", "yes");
            it.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            it.setOutputProperty("encoding", "UTF-8");
            it.transform(new DOMSource(element), new StreamResult(writer));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Element createElementNS(Node node, QName name) {
        return XMLUtils.createElementNS(node.getOwnerDocument(), name.getNamespaceURI(), name.getLocalPart());
    }

    public static Element createElementNS(Document root, QName name) {
        return XMLUtils.createElementNS(root, name.getNamespaceURI(), name.getLocalPart());
    }

    public static Element createElementNS(Document root, String namespaceURI, String qualifiedName) {
        return root.createElementNS(namespaceURI, qualifiedName);
    }

    public static Text createTextNode(Document root, String data) {
        return root.createTextNode(data);
    }

    public static Text createTextNode(Node node, String data) {
        return XMLUtils.createTextNode(node.getOwnerDocument(), data);
    }

    public static void removeContents(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node entry = list.item(i);
            node.removeChild(entry);
        }
    }

    public static String writeQName(Definition def, QName qname) {
        return def.getPrefix(qname.getNamespaceURI()) + ":" + qname.getLocalPart();
    }

    public static InputStream getInputStream(Document doc) throws Exception {
        DOMImplementationLS impl = null;
        DOMImplementation docImpl = doc.getImplementation();
        if (docImpl != null && docImpl.hasFeature("LS", "3.0")) {
            impl = (DOMImplementationLS)docImpl.getFeature("LS", "3.0");
        } else {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            if (impl == null) {
                System.setProperty("org.w3c.dom.DOMImplementationSourceList", "com.sun.org.apache.xerces.internal.dom.DOMImplementationSourceImpl");
                registry = DOMImplementationRegistry.newInstance();
                impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            }
        }
        LSOutput output = impl.createLSOutput();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        output.setByteStream(byteArrayOutputStream);
        LSSerializer writer = impl.createLSSerializer();
        writer.write(doc, output);
        byte[] buf = byteArrayOutputStream.toByteArray();
        return new ByteArrayInputStream(buf);
    }

    public static Element fetchElementByNameAttribute(Element parent, String targetName, String nameValue) {
        Element ret = null;
        NodeList nodeList = parent.getElementsByTagName(targetName);
        Node node = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (!(node instanceof Element) || !((Element)node).getAttribute("name").equals(nameValue)) continue;
            ret = (Element)node;
            break;
        }
        return ret;
    }

    public static QName getQName(String value, Node node) {
        if (value == null) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = node.lookupNamespaceURI(prefix);
        if (ns == null || localName == null) {
            throw new RuntimeException("Invalid QName in mapping: " + value);
        }
        return new QName(ns, localName, prefix);
    }

    public static Node fromSource(Source src) throws Exception {
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        DOMResult res = new DOMResult();
        trans.transform(src, res);
        return res.getNode();
    }

    static {
        omitXmlDecl = "no";
        charset = "utf-8";
        indent = -1;
        parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        transformerFactory = TransformerFactory.newInstance();
    }
}

