/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class LoggingOutInterceptor
extends AbstractPhaseInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(LoggingOutInterceptor.class);

    public LoggingOutInterceptor() {
        super("pre-stream");
        this.addBefore(StaxOutInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        OutputStream os = message.getContent(OutputStream.class);
        if (os == null) {
            return;
        }
        CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
        message.setContent(OutputStream.class, newOut);
        newOut.registerCallback(new LoggingCallback());
    }

    class LoggingCallback
    implements CachedOutputStreamCallback {
        LoggingCallback() {
        }

        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            OutputStream os = cos.getOut();
            if (os instanceof ByteArrayOutputStream && LOG.isLoggable(Level.INFO)) {
                LOG.info("Outbound Message \n--------------------------------------\n" + os.toString() + "\n--------------------------------------");
            }
        }
    }
}

