/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.wsdl.Port;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HttpURLConnectionFactory;
import org.apache.cxf.transport.http.HttpURLConnectionFactoryImpl;
import org.apache.cxf.transport.https.HttpsURLConnectionFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;
import org.xmlsoap.schemas.wsdl.http.AddressType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHTTPTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory,
WSDLEndpointFactory {
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    private Bus bus;
    private Collection<String> activationNamespaces;

    @Resource(name="bus")
    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource(name="activationNamespaces")
    public void setActivationNamespaces(Collection<String> ans) {
        this.activationNamespaces = ans;
    }

    @PostConstruct
    public void registerWithBindingManager() {
        DestinationFactoryManager dfm;
        ConduitInitiatorManager cim;
        if (null == this.bus) {
            return;
        }
        if (this.getTransportIds() == null) {
            this.setTransportIds(new ArrayList<String>(this.activationNamespaces));
        }
        if (null != (cim = this.bus.getExtension(ConduitInitiatorManager.class)) && null != this.activationNamespaces) {
            for (String ns : this.activationNamespaces) {
                cim.registerConduitInitiator(ns, this);
            }
        }
        if (null != (dfm = this.bus.getExtension(DestinationFactoryManager.class)) && null != this.activationNamespaces) {
            for (String ns : this.activationNamespaces) {
                dfm.registerDestinationFactory(ns, this);
            }
        }
    }

    @Override
    public Conduit getConduit(EndpointInfo endpointInfo) throws IOException {
        return this.getConduit(endpointInfo, endpointInfo.getTarget());
    }

    @Override
    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        HTTPConduit conduit = target == null ? new HTTPConduit(this.bus, endpointInfo) : new HTTPConduit(this.bus, endpointInfo, target);
        this.configure(conduit);
        conduit.finalizeConfig();
        return conduit;
    }

    @Override
    public abstract Destination getDestination(EndpointInfo var1) throws IOException;

    @Override
    public EndpointInfo createEndpointInfo(ServiceInfo serviceInfo, BindingInfo b, Port port) {
        if (port != null) {
            List ees = port.getExtensibilityElements();
            for (Object extensor : ees) {
                if (extensor instanceof HTTPAddress) {
                    HTTPAddress httpAdd = (HTTPAddress)extensor;
                    HttpEndpointInfo info = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
                    ((EndpointInfo)info).setAddress(httpAdd.getLocationURI());
                    ((AbstractPropertiesHolder)info).addExtensor(httpAdd);
                    return info;
                }
                if (!(extensor instanceof AddressType)) continue;
                AddressType httpAdd = (AddressType)extensor;
                HttpEndpointInfo info = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
                ((EndpointInfo)info).setAddress(httpAdd.getLocation());
                ((AbstractPropertiesHolder)info).addExtensor(httpAdd);
                return info;
            }
        }
        HttpEndpointInfo hei = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
        HttpAddressType at = new HttpAddressType();
        hei.addExtensor(at);
        return hei;
    }

    @Override
    public void createPortExtensors(EndpointInfo ei, Service service) {
    }

    @Override
    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    protected void configure(Object bean) {
        Configurer configurer = this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(bean);
        }
    }

    static HttpURLConnectionFactory getConnectionFactory(HTTPConduit configuredConduit) {
        HttpURLConnectionFactory fac = null;
        fac = configuredConduit.getTlsClientParameters() != null ? new HttpsURLConnectionFactory(configuredConduit.getTlsClientParameters()) : new HttpURLConnectionFactoryImpl();
        return fac;
    }

    static {
        URI_PREFIXES.add("http://");
        URI_PREFIXES.add("https://");
    }

    private static class HttpAddressType
    extends AddressType
    implements HTTPAddress,
    SOAPAddress {
        public HttpAddressType() {
            this.setElementType(new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address"));
        }

        public String getLocationURI() {
            return this.getLocation();
        }

        public void setLocationURI(String locationURI) {
            this.setLocation(locationURI);
        }
    }

    private static class HttpEndpointInfo
    extends EndpointInfo {
        AddressType saddress;

        HttpEndpointInfo(ServiceInfo serv, String trans) {
            super(serv, trans);
        }

        public void setAddress(String s) {
            super.setAddress(s);
            if (this.saddress != null) {
                this.saddress.setLocation(s);
            }
        }

        public void addExtensor(Object el) {
            super.addExtensor(el);
            if (el instanceof AddressType) {
                this.saddress = (AddressType)el;
            }
        }
    }
}

