/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.WSDLQueryException;
import org.apache.cxf.transports.http.StemMatchingQueryHandler;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLQueryHandler
implements StemMatchingQueryHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLQueryHandler.class, "QueryMessages");
    private Bus bus;

    public WSDLQueryHandler(Bus b) {
        this.bus = b;
    }

    @Override
    public String getResponseContentType(String baseUri, String ctx) {
        if (baseUri.toLowerCase().contains("?wsdl") || baseUri.toLowerCase().contains("?xsd=")) {
            return "text/xml";
        }
        return null;
    }

    @Override
    public boolean isRecognizedQuery(String baseUri, String ctx, EndpointInfo endpointInfo, boolean contextMatchExact) {
        if (baseUri != null && (baseUri.toLowerCase().contains("?wsdl") || baseUri.toLowerCase().contains("?xsd="))) {
            if (contextMatchExact) {
                return endpointInfo.getAddress().contains(ctx);
            }
            return endpointInfo.getAddress().contains(this.getStem(baseUri));
        }
        return false;
    }

    @Override
    public void writeResponse(String baseUri, String ctxUri, EndpointInfo endpointInfo, OutputStream os) {
        try {
            String sl;
            Element el;
            int x;
            Document doc;
            int idx = baseUri.toLowerCase().indexOf("?wsdl");
            String base = null;
            String wsdl = "";
            String xsd = null;
            if (idx != -1) {
                base = baseUri.substring(0, baseUri.toLowerCase().indexOf("?wsdl"));
                wsdl = baseUri.substring(baseUri.toLowerCase().indexOf("?wsdl") + 5);
                if (wsdl.length() > 0) {
                    wsdl = wsdl.substring(1);
                }
            } else {
                base = baseUri.substring(0, baseUri.toLowerCase().indexOf("?xsd="));
                xsd = baseUri.substring(baseUri.toLowerCase().indexOf("?xsd=") + 5);
            }
            Map<String, Definition> mp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName()));
            Map<String, SchemaReference> smp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName() + ".Schemas"));
            if (mp == null) {
                endpointInfo.getService().setProperty(WSDLQueryHandler.class.getName(), new ConcurrentHashMap());
                mp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName()));
            }
            if (smp == null) {
                endpointInfo.getService().setProperty(WSDLQueryHandler.class.getName() + ".Schemas", new ConcurrentHashMap());
                smp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName() + ".Schemas"));
            }
            if (!mp.containsKey(wsdl)) {
                Definition def = new ServiceWSDLBuilder(this.bus, endpointInfo.getService()).build();
                mp.put("", def);
                this.updateDefinition(def, mp, smp, base, endpointInfo);
            }
            if (xsd == null) {
                Definition def = (Definition)mp.get(wsdl);
                WSDLWriter wsdlWriter = this.bus.getExtension(WSDLManager.class).getWSDLFactory().newWSDLWriter();
                def.setExtensionRegistry(this.bus.getExtension(WSDLManager.class).getExtenstionRegistry());
                doc = wsdlWriter.getDocument(def);
            } else {
                SchemaReference si = (SchemaReference)smp.get(xsd);
                ResourceManagerWSDLLocator rml = new ResourceManagerWSDLLocator(si.getReferencedSchema().getDocumentBaseURI(), this.bus);
                InputSource src = rml.getBaseInputSource();
                doc = XMLUtils.getParser().parse(src);
            }
            NodeList nl = doc.getDocumentElement().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
            for (x = 0; x < nl.getLength(); ++x) {
                el = (Element)nl.item(x);
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(sl)) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl);
            }
            nl = doc.getDocumentElement().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
            for (x = 0; x < nl.getLength(); ++x) {
                el = (Element)nl.item(x);
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(sl)) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl);
            }
            nl = doc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
            for (x = 0; x < nl.getLength(); ++x) {
                el = (Element)nl.item(x);
                sl = el.getAttribute("location");
                if (!mp.containsKey(sl)) continue;
                el.setAttribute("location", base + "?wsdl=" + sl);
            }
            XMLUtils.writeTo(doc, os);
        }
        catch (WSDLException wex) {
            throw new WSDLQueryException(new Message("COULD_NOT_PROVIDE_WSDL", LOG, baseUri), (Throwable)wex);
        }
        catch (SAXException e) {
            throw new WSDLQueryException(new Message("COULD_NOT_PROVIDE_WSDL", LOG, baseUri), (Throwable)e);
        }
        catch (IOException e) {
            throw new WSDLQueryException(new Message("COULD_NOT_PROVIDE_WSDL", LOG, baseUri), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLQueryException(new Message("COULD_NOT_PROVIDE_WSDL", LOG, baseUri), (Throwable)e);
        }
    }

    protected void updateDefinition(Definition def, Map<String, Definition> done, Map<String, SchemaReference> doneSchemas, String base, EndpointInfo ei) {
        Collection<List> imports = CastUtils.cast(def.getImports().values());
        for (List lst : imports) {
            List<Import> impLst = CastUtils.cast(lst);
            for (Import imp : impLst) {
                String start = imp.getLocationURI();
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    done.put(start, imp.getDefinition());
                    this.updateDefinition(imp.getDefinition(), done, doneSchemas, base, ei);
                }
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement el : CastUtils.cast(types.getExtensibilityElements(), ExtensibilityElement.class)) {
                if (!(el instanceof Schema)) continue;
                Schema see = (Schema)el;
                this.updateSchemaImports(see, doneSchemas, base);
            }
        }
    }

    protected void updateSchemaImports(Schema schema, Map<String, SchemaReference> doneSchemas, String base) {
        Collection<List> imports = CastUtils.cast(schema.getImports().values());
        for (List lst : imports) {
            List<SchemaImport> impLst = CastUtils.cast(lst);
            for (SchemaImport imp : impLst) {
                String start = imp.getSchemaLocationURI();
                if (start == null || doneSchemas.containsKey(start)) continue;
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    doneSchemas.put(start, (SchemaReference)imp);
                    this.updateSchemaImports(imp.getReferencedSchema(), doneSchemas, base);
                }
            }
        }
        List<SchemaReference> includes = CastUtils.cast(schema.getIncludes());
        for (SchemaReference included : includes) {
            String start = included.getSchemaLocationURI();
            if (start == null || doneSchemas.containsKey(start)) continue;
            try {
                new URL(start);
            }
            catch (MalformedURLException e) {
                doneSchemas.put(start, included);
                this.updateSchemaImports(included.getReferencedSchema(), doneSchemas, base);
            }
        }
    }

    @Override
    public boolean isRecognizedQuery(String baseUri, String ctx, EndpointInfo endpointInfo) {
        return this.isRecognizedQuery(baseUri, ctx, endpointInfo, false);
    }

    private String getStem(String baseURI) {
        URL url = null;
        try {
            url = new URL(baseURI);
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "URL creation failed: ", e);
        }
        String port = String.valueOf(url.getPort());
        baseURI = baseURI.substring(baseURI.indexOf(port) + port.length(), baseURI.lastIndexOf("/"));
        return baseURI;
    }
}

