/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import javax.wsdl.xml.WSDLLocator;
import org.apache.cxf.resource.ExtendedURIResolver;
import org.apache.xml.resolver.Catalog;
import org.xml.sax.InputSource;

public class WSDLLocatorImpl
implements WSDLLocator {
    private String wsdlUrl;
    private ExtendedURIResolver resolver;
    private String baseUri;
    private String importedUri;
    private Catalog catalogResolver;

    public WSDLLocatorImpl(String wsdlUrl) {
        this.baseUri = this.wsdlUrl = wsdlUrl;
        this.resolver = new ExtendedURIResolver();
    }

    public void setCatalogResolver(Catalog cr) {
        this.catalogResolver = cr;
    }

    private InputSource resolve(String target, String base) {
        try {
            String resolvedLocation = null;
            if (this.catalogResolver != null) {
                resolvedLocation = this.catalogResolver.resolveSystem(target);
            }
            if (resolvedLocation == null) {
                return this.resolver.resolve(target, base);
            }
            return this.resolver.resolve(resolvedLocation, base);
        }
        catch (Exception e) {
            throw new RuntimeException("Catalog resolve failed: ", e);
        }
    }

    public InputSource getBaseInputSource() {
        InputSource result = this.resolve(this.baseUri, null);
        this.baseUri = this.resolver.getURI();
        return result;
    }

    public String getBaseURI() {
        return this.baseUri;
    }

    public String getLatestImportURI() {
        return this.resolver.getLatestImportURI();
    }

    public InputSource getImportInputSource(String parent, String importLocation) {
        this.baseUri = parent;
        this.importedUri = importLocation;
        return this.resolve(this.importedUri, this.baseUri);
    }

    public void close() {
        this.resolver.close();
    }
}

