/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.helpers.JavaUtils;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NamespaceHelper {
    private NamespaceHelper() {
    }

    public static String getUniquePrefix(Element element, String namespaceURI) {
        String prefix = NamespaceHelper.getPrefix(element, namespaceURI);
        if (prefix == null) {
            if ("".equals(namespaceURI)) {
                return "";
            }
            prefix = NamespaceHelper.getUniquePrefix(element);
            element.addNamespaceDeclaration(Namespace.getNamespace((String)prefix, (String)namespaceURI));
        }
        return prefix;
    }

    public static String getPrefix(Element element, String namespaceURI) {
        if (element.getNamespaceURI().equals(namespaceURI)) {
            return element.getNamespacePrefix();
        }
        List namespaces = element.getAdditionalNamespaces();
        for (Namespace ns : namespaces) {
            if (!ns.getURI().equals(namespaceURI)) continue;
            return ns.getPrefix();
        }
        if (element.getParentElement() != null) {
            return NamespaceHelper.getPrefix(element.getParentElement(), namespaceURI);
        }
        return null;
    }

    public static void getPrefixes(Element element, String namespaceURI, List<String> prefixes) {
        if (element.getNamespaceURI().equals(namespaceURI)) {
            prefixes.add(element.getNamespacePrefix());
        }
        List namespaces = element.getAdditionalNamespaces();
        for (Namespace ns : namespaces) {
            if (!ns.getURI().equals(namespaceURI)) continue;
            prefixes.add(ns.getPrefix());
        }
        if (element.getParentElement() != null) {
            NamespaceHelper.getPrefixes(element.getParentElement(), namespaceURI, prefixes);
        }
    }

    private static String getUniquePrefix(Element el) {
        int n = 1;
        String nsPrefix;
        while (el.getNamespace(nsPrefix = "ns" + n) != null) {
            ++n;
        }
        return nsPrefix;
    }

    public static String getUniquePrefix(XMLStreamWriter writer, String namespaceURI, boolean declare) throws XMLStreamException {
        String prefix = writer.getNamespaceContext().getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = NamespaceHelper.getUniquePrefix(writer);
            if (declare) {
                writer.setPrefix(prefix, namespaceURI);
                writer.writeNamespace(prefix, namespaceURI);
            }
        }
        return prefix;
    }

    public static String getUniquePrefix(XMLStreamWriter writer) {
        int n = 1;
        while (true) {
            String nsPrefix = "ns" + n;
            if (writer.getNamespaceContext().getNamespaceURI(nsPrefix) == null) {
                return nsPrefix;
            }
            ++n;
        }
    }

    public static String makeNamespaceFromClassName(String className, String protocol) {
        int index = className.lastIndexOf(".");
        if (index == -1) {
            return protocol + "://" + "DefaultNamespace";
        }
        String packageName = className.substring(0, index);
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuffer sb = new StringBuffer(80);
        for (int i = words.length - 1; i >= 0; --i) {
            String word = words[i];
            if (i != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
        }
        return protocol + "://" + sb.toString();
    }

    public static String makePackageName(String namespace) {
        String hostname = null;
        String path = "";
        try {
            URL u = new URL(namespace);
            hostname = u.getHost();
            path = u.getPath();
        }
        catch (MalformedURLException e) {
            if (namespace.indexOf(":") > -1) {
                hostname = namespace.substring(namespace.indexOf(":") + 1);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            hostname = namespace;
        }
        if (hostname == null) {
            return null;
        }
        hostname = hostname.replace('-', '_');
        if ((path = path.replace('-', '_')).length() > 0 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(hostname, ".:");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuffer sb = new StringBuffer(namespace.length());
        for (int i = words.length - 1; i >= 0; --i) {
            NamespaceHelper.addWordToPackageBuffer(sb, words[i], i == words.length - 1);
        }
        StringTokenizer st2 = new StringTokenizer(path, "/");
        while (st2.hasMoreTokens()) {
            NamespaceHelper.addWordToPackageBuffer(sb, st2.nextToken(), false);
        }
        return sb.toString();
    }

    private static void addWordToPackageBuffer(StringBuffer sb, String word, boolean firstWord) {
        if (JavaUtils.isJavaKeyword(word)) {
            word = JavaUtils.makeNonJavaKeyword(word);
        }
        if (!firstWord) {
            sb.append('.');
        }
        if (Character.isDigit(word.charAt(0))) {
            sb.append('_');
        }
        if (word.indexOf(46) != -1) {
            char[] buf = word.toCharArray();
            for (int i = 0; i < word.length(); ++i) {
                if (buf[i] != '.') continue;
                buf[i] = 95;
            }
            word = new String(buf);
        }
        sb.append(word);
    }

    public static QName readQName(XMLStreamReader reader) throws XMLStreamException {
        String value = reader.getElementText();
        if (value == null) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = reader.getNamespaceURI(prefix);
        if (ns == null || localName == null) {
            throw new DatabindingException("Invalid QName in mapping: " + value);
        }
        return new QName(ns, localName, prefix);
    }

    public static QName createQName(NamespaceContext nc, String value) {
        if (value == null) {
            return null;
        }
        int index = value.indexOf(58);
        if (index == -1) {
            return new QName(nc.getNamespaceURI(""), value, "");
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = nc.getNamespaceURI(prefix);
        return new QName(ns, localName, prefix);
    }

    public static QName createQName(Element e, String value, String defaultNamespace) {
        if (value == null) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(defaultNamespace, value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        Namespace jNS = e.getNamespace(prefix);
        if (jNS == null) {
            throw new DatabindingException("No namespace was found for prefix: " + prefix);
        }
        String ns = jNS.getURI();
        if (ns == null || localName == null) {
            throw new DatabindingException("Invalid QName in mapping: " + value);
        }
        return new QName(ns, localName, prefix);
    }
}

