/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInDatabindingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final QName XSD_ANY = new QName("http://www.w3.org/2001/XMLSchema", "anyType", "xsd");
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractInDatabindingInterceptor.class);

    public AbstractInDatabindingInterceptor(String phase) {
        super(phase);
    }

    public AbstractInDatabindingInterceptor(String i, String phase) {
        super(i, phase);
    }

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.get("org.apache.cxf.client"));
    }

    protected <T> DataReader<T> getDataReader(Message message, Class<T> input) {
        Service service = ServiceModelUtil.getService(message.getExchange());
        DataReader<T> dataReader = service.getDataBinding().createReader(input);
        if (dataReader == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_DATAREADER", BUNDLE, service.getName()));
        }
        dataReader.setAttachments(message.getAttachments());
        dataReader.setProperty(DataReader.ENDPOINT, message.getExchange().get(Endpoint.class));
        this.setSchemaInMessage(service, message, dataReader);
        return dataReader;
    }

    protected DataReader<XMLStreamReader> getDataReader(Message message) {
        return this.getDataReader(message, XMLStreamReader.class);
    }

    protected DataReader<Node> getNodeDataReader(Message message) {
        return this.getDataReader(message, Node.class);
    }

    private void setSchemaInMessage(Service service, Message message, DataReader<?> reader) {
        Object en = message.getContextualProperty("schema-validation-enabled");
        if (Boolean.TRUE.equals(en) || "true".equals(en)) {
            Schema schema = EndpointReferenceUtils.getSchema(service.getServiceInfos().get(0));
            reader.setSchema(schema);
        }
    }

    protected DepthXMLStreamReader getXMLStreamReader(Message message) {
        XMLStreamReader xr = message.getContent(XMLStreamReader.class);
        if (xr instanceof DepthXMLStreamReader) {
            return (DepthXMLStreamReader)xr;
        }
        DepthXMLStreamReader dr = new DepthXMLStreamReader(xr);
        message.setContent(XMLStreamReader.class, dr);
        return dr;
    }

    protected MessagePartInfo findMessagePart(Exchange exchange, Collection<OperationInfo> operations, QName name, boolean client, int index) {
        Endpoint ep = exchange.get(Endpoint.class);
        MessagePartInfo lastChoice = null;
        Iterator<OperationInfo> itr = operations.iterator();
        while (itr.hasNext()) {
            OperationInfo op = itr.next();
            BindingOperationInfo boi = ep.getEndpointInfo().getBinding().getOperation(op);
            if (boi == null) continue;
            BindingMessageInfo msgInfo = null;
            msgInfo = client ? boi.getOutput() : boi.getInput();
            if (msgInfo == null) {
                itr.remove();
                continue;
            }
            List<MessagePartInfo> bodyParts = msgInfo.getMessageParts();
            if (bodyParts.size() == 0 || bodyParts.size() <= index) {
                itr.remove();
                continue;
            }
            MessagePartInfo p = msgInfo.getMessageParts().get(index);
            if (name.getNamespaceURI() == null || name.getNamespaceURI().length() == 0) {
                name = new QName(p.getMessageInfo().getName().getNamespaceURI(), name.getLocalPart());
            }
            if (name.equals(p.getConcreteName())) {
                exchange.put(BindingOperationInfo.class, boi);
                exchange.put(OperationInfo.class, boi.getOperationInfo());
                exchange.setOneWay(op.isOneWay());
                return p;
            }
            if (XSD_ANY.equals(p.getTypeQName())) {
                lastChoice = p;
                continue;
            }
            itr.remove();
        }
        return lastChoice;
    }

    protected BindingOperationInfo getBindingOperationInfo(Exchange exchange, QName name, boolean client) {
        BindingOperationInfo bop;
        String local = name.getLocalPart();
        if (client && local.endsWith("Response")) {
            local = local.substring(0, local.length() - 8);
        }
        if ((bop = ServiceModelUtil.getOperation(exchange, local)) != null) {
            exchange.put(BindingOperationInfo.class, bop);
            exchange.put(OperationInfo.class, bop.getOperationInfo());
        }
        return bop;
    }

    protected MessageInfo getMessageInfo(Message message, BindingOperationInfo operation) {
        return this.getMessageInfo(message, operation, this.isRequestor(message));
    }

    protected MessageInfo getMessageInfo(Message message, BindingOperationInfo operation, boolean requestor) {
        MessageInfo msgInfo;
        OperationInfo intfOp = operation.getOperationInfo();
        if (requestor) {
            msgInfo = intfOp.getOutput();
            message.put(MessageInfo.class, intfOp.getOutput());
        } else {
            msgInfo = intfOp.getInput();
            message.put(MessageInfo.class, intfOp.getInput());
        }
        return msgInfo;
    }
}

