/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBEncoderDecoder {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXBEncoderDecoder.class);

    private JAXBEncoderDecoder() {
    }

    private static Marshaller createMarshaller(JAXBContext context, Class<?> cls) throws JAXBException {
        Marshaller jm = null;
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{cls});
        }
        jm = context.createMarshaller();
        jm.setProperty("jaxb.encoding", (Object)"UTF-8");
        jm.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return jm;
    }

    public static void marshall(JAXBContext context, Schema schema, Object elValue, MessagePartInfo part, Object source, AttachmentMarshaller am) {
        Class<?> cls = null;
        if (part != null) {
            cls = part.getTypeClass();
        }
        if (cls == null) {
            Class<?> clazz = cls = null != elValue ? elValue.getClass() : null;
        }
        if (cls != null && cls.isArray() && elValue instanceof Collection) {
            Collection col = (Collection)elValue;
            elValue = col.toArray((Object[])Array.newInstance(cls.getComponentType(), col.size()));
        }
        try {
            Marshaller u = JAXBEncoderDecoder.createMarshaller(context, cls);
            try {
                u.setProperty("jaxb.fragment", (Object)true);
                u.setProperty("jaxb.formatted.output", (Object)false);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            Object mObj = elValue;
            QName elName = null;
            if (part != null) {
                elName = part.getConcreteName();
            }
            u.setSchema(schema);
            if (am != null) {
                u.setAttachmentMarshaller(am);
            }
            if (null != elName) {
                if (part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
                    XmlSchemaElement el = (XmlSchemaElement)part.getXmlSchema();
                    if (mObj.getClass().isArray() && el.getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
                        mObj = Arrays.asList(mObj);
                        JAXBEncoderDecoder.writeObject(u, source, new JAXBElement(elName, cls, mObj));
                    } else if (part.getMessageInfo().getOperation().isUnwrapped() && (mObj.getClass().isArray() || mObj instanceof List) && el.getMaxOccurs() != 1L) {
                        Object objArray;
                        if (mObj instanceof List) {
                            List l = (List)mObj;
                            objArray = l.toArray(new Object[l.size()]);
                            cls = null;
                        } else {
                            objArray = mObj;
                            cls = objArray.getClass().getComponentType();
                        }
                        int len = Array.getLength(objArray);
                        for (int x = 0; x < len; ++x) {
                            Object o = Array.get(objArray, x);
                            JAXBEncoderDecoder.writeObject(u, source, new JAXBElement(elName, cls == null ? o.getClass() : cls, o));
                        }
                    } else {
                        JAXBEncoderDecoder.writeObject(u, source, new JAXBElement(elName, cls, mObj));
                    }
                } else if (byte[].class == cls && part.getTypeQName() != null && part.getTypeQName().getLocalPart().equals("hexBinary")) {
                    mObj = new HexBinaryAdapter().marshal((byte[])mObj);
                    JAXBEncoderDecoder.writeObject(u, source, new JAXBElement(elName, String.class, mObj));
                } else {
                    JAXBEncoderDecoder.writeObject(u, source, new JAXBElement(elName, cls, mObj));
                }
            } else {
                JAXBEncoderDecoder.writeObject(u, source, mObj);
            }
        }
        catch (Fault ex) {
            throw (Fault)ex.fillInStackTrace();
        }
        catch (Exception ex) {
            if (ex instanceof MarshalException) {
                MarshalException marshalEx = (MarshalException)ex;
                Message faultMessage = new Message("MARSHAL_ERROR", BUNDLE, marshalEx.getLinkedException().getMessage());
                throw new Fault(faultMessage, (Throwable)ex);
            }
            throw new Fault(new Message("MARSHAL_ERROR", BUNDLE, ex.getMessage()), (Throwable)ex);
        }
    }

    private static void writeObject(Marshaller u, Object source, Object mObj) throws Fault, JAXBException {
        if (source instanceof XMLStreamWriter) {
            u.marshal(mObj, (XMLStreamWriter)source);
        } else if (source instanceof OutputStream) {
            u.marshal(mObj, (OutputStream)source);
        } else if (source instanceof Node) {
            u.marshal(mObj, (Node)source);
        } else if (source instanceof XMLEventWriter) {
            u.marshal(mObj, (XMLEventWriter)source);
        } else {
            throw new Fault(new Message("UNKNOWN_SOURCE", BUNDLE, source.getClass().getName()));
        }
    }

    public static void marshall(JAXBContext context, Schema schema, Object elValue, Object source) {
        JAXBEncoderDecoder.marshall(context, schema, elValue, null, source, null);
    }

    public static void marshallNullElement(JAXBContext context, Schema schema, Object source, MessagePartInfo part) {
        Class<?> clazz = part != null ? part.getTypeClass() : null;
        try {
            Marshaller u = JAXBEncoderDecoder.createMarshaller(context, clazz);
            u.setSchema(schema);
            try {
                u.setProperty("jaxb.fragment", (Object)true);
                u.setProperty("jaxb.formatted.output", (Object)false);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            JAXBEncoderDecoder.writeObject(u, source, new JAXBElement(part.getElementQName(), clazz, null));
        }
        catch (JAXBException e) {
            throw new Fault(new Message("MARSHAL_ERROR", BUNDLE, e.getMessage()), (Throwable)e);
        }
    }

    public static void marshall(JAXBContext context, Schema schema, Object elValue, MessagePartInfo part, Object source) {
        JAXBEncoderDecoder.marshall(context, schema, elValue, part, source, null);
    }

    private static Unmarshaller createUnmarshaller(JAXBContext context, Class<?> cls) throws JAXBException {
        Unmarshaller um = null;
        if (context == null) {
            if (cls == null) {
                throw new IllegalStateException("A JAXBContext or Class to unmarshal must be provided!");
            }
            context = JAXBContext.newInstance((Class[])new Class[]{cls});
        }
        um = context.createUnmarshaller();
        return um;
    }

    public static Object unmarshall(JAXBContext context, Schema schema, Object source) {
        return JAXBEncoderDecoder.unmarshall(context, schema, source, null, null, true);
    }

    public static Object unmarshall(JAXBContext context, Schema schema, Object source, MessagePartInfo part, AttachmentUnmarshaller au, boolean unwrap) {
        List<Object> o;
        QName elName;
        Class<?> clazz = part != null ? part.getTypeClass() : null;
        QName qName = elName = part != null ? part.getConcreteName() : null;
        if (clazz != null && clazz.isArray() && part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
            XmlSchemaElement el = (XmlSchemaElement)part.getXmlSchema();
            if (el.getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
                Object obj = JAXBEncoderDecoder.unmarshall(context, schema, source, elName, null, au, unwrap);
                if (clazz.isArray() && obj instanceof List) {
                    return ((List)obj).toArray((Object[])Array.newInstance(clazz.getComponentType(), ((List)obj).size()));
                }
                return obj;
            }
            if (part.getMessageInfo().getOperation().isUnwrapped() && el.getMaxOccurs() != 1L) {
                List<Object> ret = JAXBEncoderDecoder.unmarshallArray(context, schema, source, elName, clazz.getComponentType(), au, JAXBEncoderDecoder.createList(part));
                Object[] o2 = ret;
                if (!JAXBEncoderDecoder.isList(part)) {
                    if (clazz.getComponentType().isPrimitive()) {
                        o2 = Array.newInstance(clazz.getComponentType(), ret.size());
                        for (int x = 0; x < ret.size(); ++x) {
                            Array.set(o2, x, ret.get(x));
                        }
                    } else {
                        o2 = ret.toArray((Object[])Array.newInstance(clazz.getComponentType(), ret.size()));
                    }
                }
                return o2;
            }
        } else if (byte[].class == clazz && part != null && part.getTypeQName() != null && part.getTypeQName().getLocalPart().equals("hexBinary")) {
            String obj = (String)JAXBEncoderDecoder.unmarshall(context, schema, source, elName, String.class, au, unwrap);
            return new HexBinaryAdapter().unmarshal(obj);
        }
        if ((o = JAXBEncoderDecoder.unmarshall(context, schema, source, elName, clazz, au, unwrap)) != null && o.getClass().isArray() && JAXBEncoderDecoder.isList(part)) {
            List<Object> ret = JAXBEncoderDecoder.createList(part);
            ret.addAll(Arrays.asList((Object[])o));
            o = ret;
        }
        return o;
    }

    private static List<Object> createList(MessagePartInfo part) {
        Class cls;
        Type tp2;
        Type genericType = (Type)part.getProperty("generic.type");
        if (genericType instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class && !(cls = (Class)tp2).isInterface() && List.class.isAssignableFrom(cls)) {
            try {
                return CastUtils.cast((List)cls.newInstance());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new ArrayList<Object>();
    }

    private static boolean isList(MessagePartInfo part) {
        Type tp2;
        Type genericType;
        if (part.getTypeClass().isArray() && !part.getTypeClass().getComponentType().isPrimitive() && (genericType = (Type)part.getProperty("generic.type")) instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class) {
            return Collection.class.isAssignableFrom((Class)tp2);
        }
        return false;
    }

    public static Object unmarshall(JAXBContext context, Schema schema, Object source, QName elName, Class<?> clazz, AttachmentUnmarshaller au, boolean unwrap) {
        Object obj;
        block10: {
            obj = null;
            try {
                Unmarshaller u = JAXBEncoderDecoder.createUnmarshaller(context, clazz);
                u.setSchema(schema);
                if (au != null) {
                    u.setAttachmentUnmarshaller(au);
                }
                boolean unmarshalWithClass = true;
                if (clazz == null || !clazz.isPrimitive() && !clazz.isArray() && !clazz.isEnum() && (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()))) {
                    unmarshalWithClass = false;
                }
                if (clazz != null && (clazz.getName().equals("javax.xml.datatype.XMLGregorianCalendar") || clazz.getName().equals("javax.xml.datatype.Duration"))) {
                    unmarshalWithClass = true;
                }
                if (source instanceof Node) {
                    obj = unmarshalWithClass ? u.unmarshal((Node)source, clazz) : u.unmarshal((Node)source);
                    break block10;
                }
                if (source instanceof XMLStreamReader) {
                    obj = unmarshalWithClass ? u.unmarshal((XMLStreamReader)source, clazz) : u.unmarshal((XMLStreamReader)source);
                    break block10;
                }
                if (source instanceof XMLEventReader) {
                    obj = unmarshalWithClass ? u.unmarshal((XMLEventReader)source, clazz) : u.unmarshal((XMLEventReader)source);
                    break block10;
                }
                throw new Fault(new Message("UNKNOWN_SOURCE", BUNDLE, source.getClass().getName()));
            }
            catch (Fault ex) {
                ex.fillInStackTrace();
                throw ex;
            }
            catch (Exception ex) {
                if (ex instanceof UnmarshalException) {
                    UnmarshalException unmarshalEx = (UnmarshalException)ex;
                    throw new Fault(new Message("UNMARSHAL_ERROR", BUNDLE, unmarshalEx.getLinkedException().getMessage()), (Throwable)ex);
                }
                throw new Fault(new Message("UNMARSHAL_ERROR", BUNDLE, ex.getMessage()), (Throwable)ex);
            }
        }
        return unwrap ? JAXBEncoderDecoder.getElementValue(obj) : obj;
    }

    public static Object getElementValue(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getValue();
        }
        return obj;
    }

    public static Class<?> getClassFromType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)t;
            return Array.newInstance(JAXBEncoderDecoder.getClassFromType(g.getGenericComponentType()), 0).getClass();
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t;
            return JAXBEncoderDecoder.getClassFromType(p.getRawType());
        }
        assert (false);
        throw new IllegalArgumentException("Cannot get Class object from unknown Type");
    }

    public static List<Object> unmarshallArray(JAXBContext context, Schema schema, Object source, QName elName, Class<?> clazz, AttachmentUnmarshaller au, List<Object> ret) {
        try {
            XMLStreamReader reader;
            Unmarshaller u = JAXBEncoderDecoder.createUnmarshaller(context, clazz);
            u.setSchema(schema);
            if (au != null) {
                u.setAttachmentUnmarshaller(au);
            }
            if (source instanceof XMLStreamReader) {
                reader = (XMLStreamReader)source;
            } else if (source instanceof Element) {
                reader = StaxUtils.createXMLStreamReader((Element)source);
            } else {
                throw new Fault(new Message("UNKNOWN_SOURCE", BUNDLE, source.getClass().getName()));
            }
            while (reader.getName().equals(elName)) {
                Object obj = u.unmarshal(reader, clazz);
                if (obj instanceof JAXBElement) {
                    obj = obj.getValue();
                }
                ret.add(obj);
            }
            return ret;
        }
        catch (Fault ex) {
            ex.fillInStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            if (ex instanceof UnmarshalException) {
                UnmarshalException unmarshalEx = (UnmarshalException)ex;
                throw new Fault(new Message("UNMARSHAL_ERROR", BUNDLE, unmarshalEx.getLinkedException().getMessage()), (Throwable)ex);
            }
            throw new Fault(new Message("UNMARSHAL_ERROR", BUNDLE, ex.getMessage()), (Throwable)ex);
        }
    }
}

