/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.ws.Holder;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HolderOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(HolderOutInterceptor.class);

    public HolderOutInterceptor() {
        super("pre-logical");
        this.addBefore(WrapperClassOutInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        MessageContentsList outObjects = MessageContentsList.getContentsList(message);
        Exchange exchange = message.getExchange();
        OperationInfo op = exchange.get(OperationInfo.class);
        LOG.fine("op: " + op);
        if (null != op) {
            LOG.fine("op.hasOutput(): " + op.hasOutput());
            if (op.hasOutput()) {
                LOG.fine("op.getOutput().size(): " + op.getOutput().size());
            }
        }
        if (op == null || !op.hasOutput() || op.getOutput().size() == 0) {
            LOG.fine("Returning.");
            return;
        }
        if (!Boolean.TRUE.equals(message.get("org.apache.cxf.client"))) {
            List<MessagePartInfo> parts = op.getOutput().getMessageParts();
            MessageContentsList inObjects = MessageContentsList.getContentsList(exchange.getInMessage());
            if (inObjects != null) {
                for (int x = 0; x < inObjects.size(); ++x) {
                    Object o = inObjects.get(x);
                    if (!(o instanceof Holder)) continue;
                    outObjects.set(x + 1, o);
                }
            }
            for (MessagePartInfo part : parts) {
                if (part.getIndex() <= 0) continue;
                Holder holder = (Holder)outObjects.get(part);
                outObjects.put(part, holder.value);
            }
        } else {
            List<MessagePartInfo> parts = op.getOutput().getMessageParts();
            ArrayList<Object> holders = new ArrayList<Object>(outObjects);
            for (int x = 0; x < outObjects.size(); ++x) {
                Object o = outObjects.get(x);
                if (o instanceof Holder) continue;
                holders.set(x, null);
            }
            message.put("client.holders", holders);
            for (MessagePartInfo part : parts) {
                if (part.getIndex() <= 0) continue;
                Holder holder = (Holder)outObjects.get(part.getIndex() - 1);
                outObjects.set(part.getIndex() - 1, holder.value);
            }
        }
    }
}

