/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.wsdl11;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.xml.WSDLReader;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.ToolConstants;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.tools.validator.internal.WSDL11Validator;
import org.apache.cxf.tools.wsdlto.core.AbstractWSDLBuilder;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.CustomizationParser;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBindingDeserializer;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBindingSerializer;
import org.apache.cxf.wsdl11.WSDLDefinitionBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSDefinitionBuilder
extends AbstractWSDLBuilder<Definition> {
    protected static final Logger LOG = LogUtils.getL7dLogger(JAXWSDefinitionBuilder.class);
    protected CustomizationParser cusParser;
    private WSDLDefinitionBuilder builder = new WSDLDefinitionBuilder();
    private WSDLReader wsdlReader;
    private Definition wsdlDefinition;
    private List<InputSource> jaxbBindings;
    private Element handlerChain;

    public JAXWSDefinitionBuilder() {
        ExtensionRegistry registry = this.builder.getExtenstionRegistry();
        this.registerJaxwsExtension(registry);
        this.wsdlReader = this.builder.getWSDLReader();
        this.wsdlReader.setExtensionRegistry(registry);
    }

    public Definition build() {
        String wsdlURL = (String)this.context.get("wsdlurl");
        return this.build(wsdlURL);
    }

    @Override
    public Definition build(String wsdlURL) {
        this.builder.setBus(this.bus);
        this.wsdlDefinition = this.builder.build(wsdlURL);
        this.context.put("importedDefinition", this.builder.getImportedDefinitions());
        this.checkSupported(this.wsdlDefinition);
        return this.wsdlDefinition;
    }

    private void registerJaxwsExtension(ExtensionRegistry registry) {
        this.registerJAXWSBinding(registry, Definition.class);
        this.registerJAXWSBinding(registry, Service.class);
        this.registerJAXWSBinding(registry, Fault.class);
        this.registerJAXWSBinding(registry, PortType.class);
        this.registerJAXWSBinding(registry, Operation.class);
        this.registerJAXWSBinding(registry, Binding.class);
        this.registerJAXWSBinding(registry, BindingOperation.class);
    }

    private void registerJAXWSBinding(ExtensionRegistry registry, Class clz) {
        registry.registerSerializer(clz, ToolConstants.JAXWS_BINDINGS, (ExtensionSerializer)new JAXWSBindingSerializer());
        registry.registerDeserializer(clz, ToolConstants.JAXWS_BINDINGS, (ExtensionDeserializer)new JAXWSBindingDeserializer());
        registry.mapExtensionTypes(clz, ToolConstants.JAXWS_BINDINGS, JAXWSBinding.class);
    }

    @Override
    public void customize() {
        if (!this.context.containsKey("binding")) {
            return;
        }
        this.cusParser = new CustomizationParser();
        this.cusParser.parse(this.context);
        this.jaxbBindings = this.cusParser.getJaxbBindings();
        this.handlerChain = this.cusParser.getHandlerChains();
        this.context.setJaxbBindingFiles(this.jaxbBindings);
        this.context.put("handler-chain", this.handlerChain);
        try {
            this.wsdlDefinition = this.buildCustomizedDefinition();
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_CREATE_WSDL_DEFINITION", LOG, this.cusParser.getCustomizedWSDLElement().getBaseURI());
            throw new RuntimeException(msg.toString(), e);
        }
    }

    private void checkSupported(Definition def) throws ToolException {
        if (this.isRPCEncoded(def)) {
            Message msg = new Message("UNSUPPORTED_RPC_ENCODED", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    private boolean isRPCEncoded(Definition def) {
        for (Binding binding : def.getBindings().values()) {
            String bindingStyle = SOAPBindingUtil.getBindingStyle(binding);
            for (BindingOperation bop : binding.getBindingOperations()) {
                String bopStyle = SOAPBindingUtil.getSOAPOperationStyle(bop);
                String outputUse = "";
                if (SOAPBindingUtil.getBindingOutputSOAPBody(bop) != null) {
                    outputUse = SOAPBindingUtil.getBindingOutputSOAPBody(bop).getUse();
                }
                String inputUse = "";
                if (SOAPBindingUtil.getBindingInputSOAPBody(bop) != null) {
                    inputUse = SOAPBindingUtil.getBindingInputSOAPBody(bop).getUse();
                }
                if (!SOAPBinding.Style.RPC.name().equalsIgnoreCase(bindingStyle) && !SOAPBinding.Style.RPC.name().equalsIgnoreCase(bopStyle) || !SOAPBinding.Use.ENCODED.name().equalsIgnoreCase(inputUse) && !SOAPBinding.Use.ENCODED.name().equalsIgnoreCase(outputUse)) continue;
                return true;
            }
        }
        return false;
    }

    private CustomizationParser getCustomizationParser() {
        return this.cusParser;
    }

    private Definition buildCustomizedDefinition() throws Exception {
        File tmpFile = File.createTempFile("customzied", ".wsdl");
        FileOutputStream outs = new FileOutputStream(tmpFile);
        DOMUtils.writeXml(this.getCustomizationParser().getCustomizedWSDLElement(), outs);
        FileInputStream ins = new FileInputStream(new File(tmpFile.toURI()));
        Document wsdlDoc = DOMUtils.readXml(ins);
        Definition def = this.wsdlReader.readWSDL(this.wsdlDefinition.getDocumentBaseURI(), wsdlDoc);
        FileUtils.delete(tmpFile);
        return def;
    }

    @Override
    public Definition getWSDLModel() {
        if (this.wsdlDefinition == null) {
            this.build();
            this.customize();
        }
        return this.wsdlDefinition;
    }

    public WSDLReader getWSDLReader() {
        return this.wsdlReader;
    }

    @Override
    public boolean validate(Definition def) throws ToolException {
        return new WSDL11Validator(def, this.context).isValid();
    }
}

