/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

public class RPCInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(RPCInInterceptor.class);

    public RPCInInterceptor() {
        super("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
    }

    private BindingOperationInfo getOperation(Message message, QName opName) {
        return ServiceModelUtil.getOperation(message.getExchange(), opName);
    }

    public void handleMessage(Message message) {
        if (this.isGET(message)) {
            LOG.info("RPCInInterceptor skipped in HTTP GET method");
            return;
        }
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        BindingOperationInfo operation = null;
        if (!StaxUtils.toNextElement(xmlReader)) {
            message.setContent(Exception.class, new RuntimeException("There must be a method name element."));
        }
        String opName = xmlReader.getLocalName();
        if (this.isRequestor(message) && opName.endsWith("Response")) {
            opName = opName.substring(0, opName.length() - 8);
        }
        if (message.getExchange().get(BindingOperationInfo.class) == null) {
            operation = this.getOperation(message, new QName(xmlReader.getNamespaceURI(), opName));
            if (operation == null) {
                new BareInInterceptor().handleMessage(message);
                return;
            }
            this.setMessage(message, operation);
        } else {
            operation = message.getExchange().get(BindingOperationInfo.class);
        }
        DataReader<XMLStreamReader> dr = this.getDataReader(message, XMLStreamReader.class);
        MessageInfo msg = !this.isRequestor(message) ? operation.getOperationInfo().getInput() : operation.getOperationInfo().getOutput();
        message.put(MessageInfo.class, msg);
        MessageContentsList parameters = new MessageContentsList();
        StaxUtils.nextEvent(xmlReader);
        boolean hasNext = true;
        Iterator<MessagePartInfo> itr = msg.getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo part = itr.next();
            if (hasNext) {
                hasNext = StaxUtils.toNextElement(xmlReader);
            }
            if (!hasNext) continue;
            QName qn = xmlReader.getName();
            while (!qn.getLocalPart().equals(part.getConcreteName().getLocalPart()) && itr.hasNext()) {
                part = itr.next();
            }
            if (!qn.equals(part.getConcreteName())) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("UNKNOWN_RPC_LIT_PART", LOG, qn));
            }
            parameters.put(part, dr.read(part, xmlReader));
        }
        message.setContent(List.class, parameters);
    }

    private void setMessage(Message message, BindingOperationInfo operation) {
        Exchange ex = message.getExchange();
        ex.put(BindingOperationInfo.class, operation);
        ex.put(OperationInfo.class, operation.getOperationInfo());
        ex.setOneWay(operation.getOperationInfo().isOneWay());
        message.put("javax.xml.ws.wsdl.operation", operation.getName());
        ServiceInfo si = operation.getBinding().getService();
        QName serviceQName = si.getName();
        message.put("javax.xml.ws.wsdl.service", serviceQName);
        QName interfaceQName = si.getInterface().getName();
        message.put("javax.xml.ws.wsdl.interface", interfaceQName);
        EndpointInfo endpointInfo = ex.get(Endpoint.class).getEndpointInfo();
        QName portQName = endpointInfo.getName();
        message.put("javax.xml.ws.wsdl.port", portQName);
        URI wsdlDescription = endpointInfo.getProperty("URI", URI.class);
        if (wsdlDescription == null) {
            String address = endpointInfo.getAddress();
            try {
                wsdlDescription = new URI(address + "?wsdl");
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            endpointInfo.setProperty("URI", wsdlDescription);
        }
        message.put("javax.xml.ws.wsdl.description", wsdlDescription);
    }
}

