/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class LoggingOutInterceptor
extends AbstractPhaseInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(LoggingOutInterceptor.class);
    private int limit = 102400;
    private boolean enabled;

    public LoggingOutInterceptor() {
        super("pre-stream");
        this.addBefore(StaxOutInterceptor.class.getName());
    }

    public LoggingOutInterceptor(int lim) {
        this();
        this.limit = lim;
    }

    public LoggingOutInterceptor(boolean b) {
        this();
        this.enabled = b;
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    public void handleMessage(Message message) throws Fault {
        OutputStream os = message.getContent(OutputStream.class);
        if (os == null) {
            return;
        }
        if (LOG.isLoggable(Level.INFO) || this.enabled) {
            CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
            message.setContent(OutputStream.class, newOut);
            newOut.registerCallback(new LoggingCallback());
        }
    }

    class LoggingCallback
    implements CachedOutputStreamCallback {
        LoggingCallback() {
        }

        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            LoggingMessage buffer = new LoggingMessage("Outbound Message\n---------------------------");
            if (cos.getTempFile() == null) {
                if (cos.size() > LoggingOutInterceptor.this.limit) {
                    buffer.getMessage().append("(message truncated to " + LoggingOutInterceptor.this.limit + " bytes)\n");
                }
            } else {
                buffer.getMessage().append("Outbound Message (saved to tmp file):\n");
                buffer.getMessage().append("Filename: " + cos.getTempFile().getAbsolutePath() + "\n");
                if (cos.size() > LoggingOutInterceptor.this.limit) {
                    buffer.getMessage().append("(message truncated to " + LoggingOutInterceptor.this.limit + " bytes)\n");
                }
            }
            try {
                cos.writeCacheTo(buffer.getPayload(), LoggingOutInterceptor.this.limit);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(buffer.toString());
            }
        }
    }
}

