/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service;

import org.apache.cxf.common.xmlschema.InvalidXmlSchemaReferenceException;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;

public class ServiceModelSchemaValidator
extends ServiceModelVisitor {
    private SchemaCollection schemaCollection;
    private StringBuilder complaints;

    public ServiceModelSchemaValidator(ServiceInfo serviceInfo) {
        super(serviceInfo);
        this.schemaCollection = serviceInfo.getXmlSchemaCollection();
        this.complaints = new StringBuilder();
    }

    public String getComplaints() {
        return this.complaints.toString();
    }

    public void begin(FaultInfo fault) {
        try {
            this.schemaCollection.validateQNameNamespace(fault.getFaultName());
            this.schemaCollection.validateQNameNamespace(fault.getName());
        }
        catch (InvalidXmlSchemaReferenceException ixsre) {
            this.complaints.append(fault.getName() + " fault name " + ixsre.getMessage() + "\n");
        }
    }

    public void begin(InterfaceInfo intf) {
        try {
            this.schemaCollection.validateQNameNamespace(intf.getName());
        }
        catch (InvalidXmlSchemaReferenceException ixsre) {
            this.complaints.append(intf.getName() + " interface name " + ixsre.getMessage() + "\n");
        }
    }

    public void begin(MessageInfo msg) {
        try {
            this.schemaCollection.validateQNameNamespace(msg.getName());
        }
        catch (InvalidXmlSchemaReferenceException ixsre) {
            this.complaints.append(msg.getName() + " message name " + ixsre.getMessage() + "\n");
        }
    }

    public void begin(MessagePartInfo part) {
        try {
            this.schemaCollection.validateQNameNamespace(part.getConcreteName());
        }
        catch (InvalidXmlSchemaReferenceException ixsre) {
            this.complaints.append(part.getName() + " part concrete name " + ixsre.getMessage() + "\n");
        }
        try {
            this.schemaCollection.validateQNameNamespace(part.getName());
        }
        catch (InvalidXmlSchemaReferenceException ixsre) {
            this.complaints.append(part.getName() + " part name " + ixsre.getMessage() + "\n");
        }
        if (part.isElement()) {
            try {
                this.schemaCollection.validateElementName(part.getName(), part.getElementQName());
            }
            catch (InvalidXmlSchemaReferenceException ixsre) {
                this.complaints.append(part.getName() + " part element name " + ixsre.getMessage() + "\n");
            }
        } else if (part.getTypeQName() == null) {
            this.complaints.append(part.getName() + " part type QName null.\n");
        } else {
            try {
                this.schemaCollection.validateTypeName(part.getName(), part.getTypeQName());
            }
            catch (InvalidXmlSchemaReferenceException ixsre) {
                this.complaints.append(part.getName() + " part type name " + ixsre.getMessage() + "\n");
            }
        }
    }

    public void begin(OperationInfo op) {
        try {
            this.schemaCollection.validateQNameNamespace(op.getName());
        }
        catch (InvalidXmlSchemaReferenceException ixsre) {
            this.complaints.append(op.getName() + " operation " + ixsre.getMessage() + "\n");
        }
    }

    public void begin(ServiceInfo service) {
        try {
            this.schemaCollection.validateQNameNamespace(service.getName());
        }
        catch (InvalidXmlSchemaReferenceException ixsre) {
            this.complaints.append(service.getName() + " service " + ixsre.getMessage() + "\n");
        }
    }

    public void begin(UnwrappedOperationInfo op) {
        try {
            this.schemaCollection.validateQNameNamespace(op.getName());
        }
        catch (InvalidXmlSchemaReferenceException ixsre) {
            this.complaints.append(op.getName() + " unwrapped operation " + ixsre.getMessage() + "\n");
        }
    }
}

