/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.factory;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.ParamReader;
import org.apache.cxf.helpers.ServiceUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceConfiguration
extends AbstractServiceConfiguration {
    @Override
    public QName getOperationName(InterfaceInfo service, Method method) {
        String local;
        String ns = service.getName().getNamespaceURI();
        QName name = new QName(ns, local = method.getName());
        if (service.getOperation(name) == null) {
            return name;
        }
        int i = 1;
        while (service.getOperation(name = new QName(ns, local + i)) != null) {
            ++i;
        }
        return name;
    }

    @Override
    public QName getFaultName(InterfaceInfo service, OperationInfo o, Class<?> exClass, Class<?> beanClass) {
        String name = ServiceUtils.makeServiceNameFromClassName(beanClass);
        return new QName(service.getName().getNamespaceURI(), name);
    }

    @Override
    public QName getInPartName(OperationInfo op, Method method, int paramNumber) {
        return this.getInParameterName(op, method, paramNumber);
    }

    @Override
    public QName getOutPartName(OperationInfo op, Method method, int paramNumber) {
        return this.getOutParameterName(op, method, paramNumber);
    }

    @Override
    public QName getInParameterName(OperationInfo op, Method method, int paramNumber) {
        return new QName(op.getName().getNamespaceURI(), this.getDefaultLocalName(op, method, paramNumber, "arg"));
    }

    @Override
    public QName getInputMessageName(OperationInfo op, Method method) {
        return new QName(op.getName().getNamespaceURI(), op.getName().getLocalPart());
    }

    @Override
    public QName getOutParameterName(OperationInfo op, Method method, int paramNumber) {
        return new QName(op.getName().getNamespaceURI(), this.getDefaultLocalName(op, method, paramNumber, "return"));
    }

    private String getDefaultLocalName(OperationInfo op, Method method, int paramNumber, String prefix) {
        Class<?> impl = this.getServiceFactory().getServiceClass();
        if (impl == null) {
            try {
                method = impl.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception e) {
                throw new ServiceConstructionException(e);
            }
        }
        return DefaultServiceConfiguration.createName(method, paramNumber, op.getInput().getMessageParts().size(), false, prefix);
    }

    public static String createName(Method method, int paramNumber, int currentSize, boolean addMethodName, String flow) {
        String paramName = "";
        if (paramNumber != -1) {
            String[] names = ParamReader.getParameterNamesFromDebugInfo(method);
            if (names != null && names[paramNumber] != null) {
                paramName = names[paramNumber];
                addMethodName = false;
            } else {
                paramName = flow + currentSize;
            }
        } else {
            paramName = flow;
        }
        paramName = addMethodName ? method.getName() + paramName : paramName;
        return paramName;
    }

    @Override
    public QName getOutputMessageName(OperationInfo op, Method method) {
        return new QName(op.getName().getNamespaceURI(), op.getName().getLocalPart() + "Response");
    }

    @Override
    public QName getInterfaceName() {
        return new QName(this.getServiceFactory().getServiceNamespace(), this.getServiceName() + "PortType");
    }

    @Override
    public QName getEndpointName() {
        return new QName(this.getServiceFactory().getServiceNamespace(), this.getServiceName() + "Port");
    }

    @Override
    public String getServiceName() {
        return this.getServiceFactory().getServiceClass().getSimpleName();
    }

    @Override
    public String getServiceNamespace() {
        String ret = super.getServiceNamespace();
        if (ret == null) {
            ret = ServiceUtils.makeNamespaceFromClassName(this.getServiceFactory().getServiceClass().getName(), "http");
        }
        return ret;
    }

    @Override
    public Boolean hasOutMessage(Method m) {
        if (m.getReturnType().getClass().equals(Void.TYPE) && m.getExceptionTypes().length == 0) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean isAsync(Method method) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean isHeader(Method method, int j) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean isInParam(Method method, int j) {
        if (j >= 0) {
            Class<?> c = method.getParameterTypes()[j];
            if (Exchange.class.equals(c)) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean isOperation(Method method) {
        if (this.getServiceFactory().getIgnoredClasses().contains(method.getDeclaringClass().getName())) {
            return Boolean.FALSE;
        }
        for (Method m : this.getServiceFactory().getIgnoredMethods()) {
            if (!m.getName().equals(method.getName()) || !Arrays.equals(method.getParameterTypes(), m.getParameterTypes()) || m.getReturnType() != method.getReturnType()) continue;
            return Boolean.FALSE;
        }
        int modifiers = method.getModifiers();
        if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean isOutParam(Method method, int j) {
        return j < 0;
    }

    @Override
    public Boolean isWrapped(Method m) {
        return this.getServiceFactory().isWrapped();
    }
}

