/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.model;

import javax.xml.namespace.QName;
import org.apache.cxf.service.model.AbstractDescriptionElement;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointInfo
extends AbstractDescriptionElement {
    String transportId;
    ServiceInfo service;
    BindingInfo binding;
    QName name;
    EndpointReferenceType address;

    public EndpointInfo() {
    }

    public EndpointInfo(ServiceInfo serv, String ns) {
        this.transportId = ns;
        this.service = serv;
    }

    public String getTransportId() {
        return this.transportId;
    }

    public void setTransportId(String tid) {
        this.transportId = tid;
    }

    public InterfaceInfo getInterface() {
        return this.service.getInterface();
    }

    public ServiceInfo getService() {
        return this.service;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName n) {
        this.name = n;
    }

    public BindingInfo getBinding() {
        return this.binding;
    }

    public void setBinding(BindingInfo b) {
        this.binding = b;
    }

    public String getAddress() {
        return null != this.address ? this.address.getAddress().getValue() : null;
    }

    public void setAddress(String addr) {
        if (null == this.address) {
            this.address = EndpointReferenceUtils.getEndpointReference(addr);
        } else {
            EndpointReferenceUtils.setAddress(this.address, addr);
        }
    }

    public void setAddress(EndpointReferenceType endpointReference) {
        this.address = endpointReference;
    }

    @Override
    public <T> T getTraversedExtensor(T defaultValue, Class<T> type) {
        T value = this.getExtensor(type);
        if (value == null) {
            if (value == null && this.binding != null) {
                value = this.binding.getExtensor(type);
            }
            if (this.service != null && value == null) {
                value = this.service.getExtensor(type);
            }
            if (value == null) {
                value = defaultValue;
            }
        }
        return value;
    }

    public EndpointReferenceType getTarget() {
        return this.address;
    }
}

