/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSS4JOutInterceptor
extends AbstractWSS4JInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JOutInterceptor.class);
    private static final Logger TIME_LOG = LogUtils.getL7dLogger(WSS4JOutInterceptor.class, null, WSS4JOutInterceptor.class.getName() + "-Time");

    public WSS4JOutInterceptor() {
        this.setPhase("post-protocol");
    }

    public WSS4JOutInterceptor(Map<String, Object> props) {
        this();
        this.setProperties(props);
    }

    @Override
    public void handleMessage(SoapMessage mc) throws Fault {
        boolean doDebug = LOG.isLoggable(Level.FINE);
        boolean doTimeDebug = TIME_LOG.isLoggable(Level.FINE);
        SoapVersion version = mc.getVersion();
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (doTimeDebug) {
            t0 = System.currentTimeMillis();
        }
        if (doDebug) {
            LOG.fine("WSDoAllSender: enter invoke()");
        }
        RequestData reqData = new RequestData();
        reqData.setMsgContext((Object)mc);
        try {
            SOAPMessage saaj;
            String username;
            Vector actions = new Vector();
            String action = this.getString("action", mc);
            if (action == null) {
                throw new SoapFault(new Message("NO_ACTION", LOG, new Object[0]), version.getReceiver());
            }
            int doAction = WSSecurityUtil.decodeAction((String)action, actions);
            if (doAction == 0) {
                return;
            }
            reqData.setUsername((String)this.getOption("user"));
            if ((reqData.getUsername() == null || reqData.getUsername().equals("")) && (username = (String)this.getProperty(reqData.getMsgContext(), "user")) != null) {
                reqData.setUsername(username);
            }
            if ((doAction & 0x43) != 0 && (reqData.getUsername() == null || reqData.getUsername().equals(""))) {
                throw new SoapFault(new Message("NO_USERNAME", LOG, new Object[0]), version.getReceiver());
            }
            if (doDebug) {
                LOG.fine("Action: " + doAction);
                LOG.fine("Actor: " + reqData.getActor());
            }
            if ((saaj = mc.getContent(SOAPMessage.class)) == null) {
                LOG.warning("SAAJOutHandler must be enabled for WS-Security!");
                throw new SoapFault(new Message("NO_SAAJ_DOC", LOG, new Object[0]), version.getReceiver());
            }
            SOAPPart doc = saaj.getSOAPPart();
            if (mc == null) {
                return;
            }
            if (doTimeDebug) {
                t1 = System.currentTimeMillis();
            }
            this.doSenderAction(doAction, (Document)doc, reqData, actions, !Boolean.TRUE.equals(this.getProperty(mc, "org.apache.cxf.client")));
            if (doTimeDebug) {
                t2 = System.currentTimeMillis();
                TIME_LOG.fine("Send request: total= " + (t2 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + "\n");
            }
            if (doDebug) {
                LOG.fine("WSDoAllSender: exit invoke()");
            }
        }
        catch (WSSecurityException e) {
            throw new SoapFault(new Message("SECURITY_FAILED", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }
}

