/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static URL getResource(String resourceName, Class callingClass) {
        ClassLoader cl;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            url = ClassLoaderUtils.class.getClassLoader().getResource(resourceName);
        }
        if (url == null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        if (url == null) {
            url = callingClass.getResource(resourceName);
        }
        if (url == null && resourceName != null && resourceName.charAt(0) != '/') {
            return ClassLoaderUtils.getResource('/' + resourceName, callingClass);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass) {
        URL url = ClassLoaderUtils.getResource(resourceName, callingClass);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Class loadClass(String className, Class callingClass) throws ClassNotFoundException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(className);
            }
            return ClassLoaderUtils.loadClass2(className, callingClass);
        }
        catch (ClassNotFoundException e) {
            return ClassLoaderUtils.loadClass2(className, callingClass);
        }
    }

    private static Class loadClass2(String className, Class callingClass) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            try {
                return ClassLoaderUtils.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException exc) {
                return callingClass.getClassLoader().loadClass(className);
            }
        }
    }
}

