/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.source;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDataBinding {
    private Collection<DOMSource> schemas;
    private Map<String, String> namespaceMap;

    public Collection<DOMSource> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Collection<DOMSource> schemas) {
        this.schemas = schemas;
    }

    protected XmlSchema addSchemaDocument(ServiceInfo serviceInfo, SchemaCollection col, Document d, String systemId) {
        String ns = d.getDocumentElement().getAttribute("targetNamespace");
        if (StringUtils.isEmpty(ns)) {
            ns = serviceInfo.getInterface().getName().getNamespaceURI();
            d.getDocumentElement().setAttribute("targetNamespace", ns);
        }
        NodeList nodes = d.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e;
            Node n = nodes.item(i);
            if (!(n instanceof Element) || !(e = (Element)n).getLocalName().equals("import")) continue;
            e.removeAttribute("schemaLocation");
        }
        SchemaInfo schema = new SchemaInfo(serviceInfo, ns);
        schema.setSystemId(systemId);
        XmlSchema xmlSchema = col.read(d.getDocumentElement());
        schema.setSchema(xmlSchema);
        serviceInfo.addSchema(schema);
        return xmlSchema;
    }

    public Map<String, String> getNamespaceMap() {
        return this.namespaceMap;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        if (namespaceMap != null) {
            HashSet prefixesSoFar = new HashSet();
            for (Map.Entry<String, String> mapping : namespaceMap.entrySet()) {
                if (!prefixesSoFar.contains(mapping.getValue())) continue;
                throw new IllegalArgumentException("Duplicate prefix " + mapping.getValue());
            }
        }
        this.namespaceMap = namespaceMap;
    }

    public Map<String, String> getDeclaredNamespaceMappings() {
        return this.namespaceMap;
    }

    protected static void checkNamespaceMap(Map<String, String> namespaceMap) {
        if (namespaceMap != null) {
            HashSet prefixesSoFar = new HashSet();
            for (Map.Entry<String, String> mapping : namespaceMap.entrySet()) {
                if (!prefixesSoFar.contains(mapping.getValue())) continue;
                throw new IllegalArgumentException("Duplicate prefix " + mapping.getValue());
            }
        }
    }
}

